/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.core.utils;

import java.text.DecimalFormat;

public class ByteSizeUtil {
    public static String byteSize2China(long byteSize, DecimalFormat decimalFormat) {
        double size = (double)byteSize * 1.0;
        if (size < 1024.0) {
            return size + "B";
        }
        if ((size /= 1024.0) < 1024.0) {
            return decimalFormat.format(size) + "KB";
        }
        if ((size /= 1024.0) < 1024.0) {
            return decimalFormat.format(size) + "MB";
        }
        return decimalFormat.format(size / 1024.0) + "GB";
    }

    public static String convertSize(long byteSize) {
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        return ByteSizeUtil.byteSize2China(byteSize, decimalFormat);
    }
}

