/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.core.toolkit;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import org.wu.framework.core.utils.ObjectUtils;

public final class DynamicLazyAttributeContextHolder {
    private static final ThreadLocal<Deque<Map<Class, Object>>> LOOKUP_KEY_HOLDER = ThreadLocal.withInitial(ArrayDeque::new);

    private DynamicLazyAttributeContextHolder() {
    }

    public static <T> T peek(Class clazz) {
        Map<Class, Object> peek = DynamicLazyAttributeContextHolder.peek();
        if (ObjectUtils.isEmpty(peek)) {
            return null;
        }
        return (T)LOOKUP_KEY_HOLDER.get().peek().get(clazz);
    }

    public static Map<Class, Object> peek() {
        return LOOKUP_KEY_HOLDER.get().peek();
    }

    public static <T> void push(Class clazz, T attribute) {
        if (null == attribute) {
            return;
        }
        Map<Class, Object> peek = DynamicLazyAttributeContextHolder.peek();
        if (null == peek) {
            peek = new HashMap<Class, Object>();
        }
        peek.put(clazz, attribute);
        LOOKUP_KEY_HOLDER.get().push(peek);
    }

    public static void poll() {
        Deque<Map<Class, Object>> deque = LOOKUP_KEY_HOLDER.get();
        deque.poll();
        if (deque.isEmpty()) {
            LOOKUP_KEY_HOLDER.remove();
        }
    }

    public static void clear() {
        LOOKUP_KEY_HOLDER.remove();
    }

    public static void clear(Class clazz) {
        Map<Class, Object> peek = LOOKUP_KEY_HOLDER.get().peek();
        if (null == peek) {
            return;
        }
        peek.remove(clazz);
        DynamicLazyAttributeContextHolder.clear();
        LOOKUP_KEY_HOLDER.get().push(peek);
    }
}

