/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.core.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.wu.framework.core.exception.AssertFactory;
import org.wu.framework.core.io.ScriptResource;
import org.wu.framework.core.utils.ClassUtils;

public class ClassPathScriptResource
implements ScriptResource {
    private final String path;
    private final ClassLoader classLoader;
    private final Class<?> clazz;

    public ClassPathScriptResource(String path) {
        this(path, null);
    }

    public ClassPathScriptResource(String path, ClassLoader classLoader) {
        AssertFactory.notNull(path, "Path must not be null");
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        this.path = path;
        this.classLoader = classLoader != null ? classLoader : ClassUtils.getDefaultClassLoader();
        this.clazz = null;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream is = this.clazz != null ? this.clazz.getResourceAsStream(this.path) : (this.classLoader != null ? this.classLoader.getResourceAsStream(this.path) : ClassLoader.getSystemResourceAsStream(this.path));
        if (is == null) {
            throw new FileNotFoundException(" cannot be opened because it does not exist");
        }
        return is;
    }
}

