/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.core.enums;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import lombok.Generated;

public enum SimulationEnum {
    INT(Integer.TYPE, length -> {
        if (null == length) {
            return SimulationEnum.getRandom().nextInt();
        }
        return SimulationEnum.getRandom().nextInt(length);
    }),
    INTEGER(Integer.class, length -> {
        if (null == length) {
            return SimulationEnum.getRandom().nextInt();
        }
        return SimulationEnum.getRandom().nextInt(length);
    }),
    LONG(Long.TYPE, new SimulationStrategy(){

        @Override
        public Object strategy(Integer length) {
            if (null == length) {
                return SimulationEnum.getRandom().nextLong();
            }
            return SimulationEnum.getRandom().nextInt(length);
        }

        @Override
        public Object text(Integer length) {
            return this.strategy(length) + "l";
        }
    }),
    PACKAGING_LONG(Long.class, new SimulationStrategy(){

        @Override
        public Object strategy(Integer length) {
            if (null == length) {
                return SimulationEnum.getRandom().nextLong();
            }
            return SimulationEnum.getRandom().nextInt(length);
        }

        @Override
        public Object text(Integer length) {
            return this.strategy(length) + "L";
        }
    }),
    DOUBLE(Double.TYPE, new SimulationStrategy(){

        @Override
        public Object strategy(Integer length) {
            return SimulationEnum.getRandom().nextDouble();
        }

        @Override
        public Object text(Integer length) {
            return this.strategy(length) + "d";
        }
    }),
    PACKAGING_DOUBLE(Double.class, new SimulationStrategy(){

        @Override
        public Object strategy(Integer length) {
            return SimulationEnum.getRandom().nextDouble();
        }

        @Override
        public Object text(Integer length) {
            return this.strategy(length) + "D";
        }
    }),
    FLOAT(Float.TYPE, new SimulationStrategy(){

        @Override
        public Object strategy(Integer length) {
            return Float.valueOf(SimulationEnum.getRandom().nextFloat());
        }

        @Override
        public Object text(Integer length) {
            return this.strategy(length) + "f";
        }
    }),
    PACKAGING_FLOAT(Float.class, new SimulationStrategy(){

        @Override
        public Object strategy(Integer length) {
            return Float.valueOf(SimulationEnum.getRandom().nextFloat());
        }

        @Override
        public Object text(Integer length) {
            return this.strategy(length) + "F";
        }
    }),
    BOOLEAN(Boolean.TYPE, new SimulationStrategy(){

        @Override
        public Object strategy(Integer length) {
            return SimulationEnum.getRandom().nextBoolean();
        }

        @Override
        public Object text(Integer length) {
            return this.strategy(length);
        }
    }),
    PACKAGING_BOOLEAN(Boolean.class, new SimulationStrategy(){

        @Override
        public Object strategy(Integer length) {
            return SimulationEnum.getRandom().nextBoolean();
        }

        @Override
        public Object text(Integer length) {
            return this.strategy(length);
        }
    }),
    DATE(java.util.Date.class, new SimulationStrategy(){

        @Override
        public Object strategy(Integer length) {
            return new java.util.Date();
        }

        @Override
        public Object text(Integer length) {
            java.util.Date date = new java.util.Date();
            return String.format("new java.util.Date(%sL)", date.getTime());
        }
    }),
    SQL_DATE(Date.class, new SimulationStrategy(){

        @Override
        public Object strategy(Integer length) {
            java.util.Date date = new java.util.Date();
            return new Date(date.getTime());
        }

        @Override
        public Object text(Integer length) {
            java.util.Date date = new java.util.Date();
            return String.format("new java.sql.Date(%sL)", date.getTime());
        }
    }),
    LOCAL_DATE_TIME(LocalDateTime.class, new SimulationStrategy(){

        @Override
        public Object strategy(Integer length) {
            return LocalDateTime.now();
        }

        @Override
        public Object text(Integer length) {
            LocalDateTime now = LocalDateTime.now();
            return String.format("LocalDateTime.of(%s,%s,%s,%s,%s,%s)", now.getYear(), now.getMonth(), now.getDayOfYear(), now.getHour(), now.getMinute(), now.getSecond());
        }
    }),
    LOCAL_DATE(LocalDate.class, new SimulationStrategy(){

        @Override
        public Object strategy(Integer length) {
            return LocalDate.now();
        }

        @Override
        public Object text(Integer length) {
            LocalDate now = LocalDate.now();
            return String.format("LocalDate.of(%s,%s,%s)", now.getYear(), now.getMonth(), now.getDayOfYear());
        }
    }),
    BIG_DECIMAL(BigDecimal.class, new SimulationStrategy(){

        @Override
        public Object strategy(Integer length) {
            if (null == length) {
                return new BigDecimal(SimulationEnum.getRandom().nextInt());
            }
            return new BigDecimal(SimulationEnum.getRandom().nextInt(length));
        }
    }),
    STRING(String.class, new SimulationStrategy(){

        @Override
        public Object strategy(Integer length) {
            if (null == length) {
                return SimulationEnum.getRandomChar(SimulationEnum.getRandom().nextInt(3));
            }
            return SimulationEnum.getRandomChar(length);
        }

        @Override
        public Object text(Integer length) {
            return "'" + this.strategy(length) + "'";
        }
    }),
    MAP(Map.class, new SimulationStrategy(){

        @Override
        public Object strategy(Integer length) {
            return new HashMap();
        }
    }),
    FILE(File.class, new SimulationStrategy(){

        @Override
        public Object strategy(Integer length) {
            return null;
        }

        @Override
        public Object text(Integer length) {
            return "";
        }
    });

    public static Map<Class<?>, SimulationStrategy> SIMULATION_MAP;
    private Class javaType;
    private SimulationStrategy simulation;

    private static Random getRandom() {
        return new Random();
    }

    private static String getRandomChar(int length) {
        StringBuilder character = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char randomChar = SimulationEnum.getRandomChar();
            character.append(randomChar);
        }
        return character.toString();
    }

    private static char getRandomChar() {
        String str = "";
        Random random = SimulationEnum.getRandom();
        int heightPos = 176 + Math.abs(random.nextInt(39));
        int lowPos = 161 + Math.abs(random.nextInt(93));
        byte[] b = new byte[]{Integer.valueOf(heightPos).byteValue(), Integer.valueOf(lowPos).byteValue()};
        try {
            str = new String(b, "GBK");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            System.out.println("\u9519\u8bef");
        }
        return str.charAt(0);
    }

    @Generated
    public Class getJavaType() {
        return this.javaType;
    }

    @Generated
    public SimulationStrategy getSimulation() {
        return this.simulation;
    }

    @Generated
    private SimulationEnum(Class javaType, SimulationStrategy simulation) {
        this.javaType = javaType;
        this.simulation = simulation;
    }

    @Generated
    private SimulationEnum() {
    }

    static {
        SIMULATION_MAP = Arrays.stream(SimulationEnum.values()).collect(Collectors.toMap(SimulationEnum::getJavaType, SimulationEnum::getSimulation));
    }

    public static class DefaultSimulationStrategy
    implements SimulationStrategy {
        @Override
        public Object strategy(Integer length) {
            return null;
        }

        @Override
        public Object text(Integer length) {
            return null;
        }
    }

    public static interface SimulationStrategy {
        public Object strategy(Integer var1);

        default public Object strategy() {
            return this.strategy(null);
        }

        default public Object text(Integer length) {
            return this.strategy(length);
        }

        default public Object text() {
            return "'" + this.text(null) + "'";
        }
    }
}

