/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.wu.framework.core.ReflexUtils;
import org.wu.framework.core.annotation.AliasFor;
import org.wu.framework.core.annotation.MergedAnnotationElement;
import org.wu.framework.core.exception.AssertFactory;
import org.wu.framework.core.exception.RuntimeExceptionFactory;
import org.wu.framework.core.utils.ObjectUtils;

final class SynthesizedMergedAnnotationElementInvocationHandler<A extends Annotation>
implements InvocationHandler {
    private final MergedAnnotationElement annotationElement;
    private final Class<A> type;
    private final Map<String, Object> valueCache = new ConcurrentHashMap<String, Object>(8);
    private volatile Integer hashCode;
    private volatile String string;

    private SynthesizedMergedAnnotationElementInvocationHandler(MergedAnnotationElement annotationElement, Class<A> type) {
        AssertFactory.notNull(annotationElement, "MergedAnnotation must not be null");
        AssertFactory.notNull(type, "Type must not be null");
        AssertFactory.isFalse(type.isAnnotation(), "Type must be an annotationElement");
        this.annotationElement = annotationElement;
        this.type = type;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        if (ReflexUtils.isToStringMethod(method)) {
            return this.toString(this.type);
        }
        if (this.isAnnotationTypeMethod(method)) {
            return this.type;
        }
        return this.getAttributeValue(method);
    }

    private boolean isAnnotationTypeMethod(Method method) {
        return method.getName().equals("annotationType") && method.getParameterCount() == 0;
    }

    private String toString(Class<A> value) {
        return value.toString();
    }

    private Object getAttributeValue(Method method) {
        Object value = this.valueCache.computeIfAbsent(method.getName(), attributeName -> {
            Class<?> type = method.getReturnType();
            return this.getAttributeValue(Collections.singletonList(this.annotationElement), method);
        });
        return value;
    }

    private Object getAttributeValue(List<MergedAnnotationElement> mergedAnnotationElementList, Method method) {
        for (MergedAnnotationElement mergedAnnotationElement : mergedAnnotationElementList) {
            if (!ObjectUtils.isEmpty(mergedAnnotationElement.getAnnotationMethodList()) && mergedAnnotationElement.getAnnotationMethodList().stream().anyMatch(method1 -> method1.equals(method))) {
                AnnotatedElement element = mergedAnnotationElement.getElement();
                Annotation source = mergedAnnotationElement.getSource();
                return ReflexUtils.invokeDeclaredMethod((Object)source, method, new Object[0]);
            }
            if (ObjectUtils.isEmpty(mergedAnnotationElement.getAnnotationMethodList())) {
                Object attributeValue = this.getAttributeValue(mergedAnnotationElement.getMergedAnnotationClassList(), method);
                if (attributeValue == null) continue;
                return attributeValue;
            }
            String targetMethodName = method.getName();
            List aliasForMethodList = mergedAnnotationElement.getAnnotationMethodList().stream().filter(annotationMethod -> {
                String annotationMethodName = annotationMethod.getName();
                AliasFor aliasFor = annotationMethod.getAnnotation(AliasFor.class);
                if (aliasFor != null && aliasFor.annotation().equals(method.getDeclaringClass())) {
                    if (aliasFor.attribute().equals(targetMethodName) || aliasFor.value().equals(method.getName())) {
                        return true;
                    }
                    if (ObjectUtils.isEmpty(aliasFor.attribute()) && ObjectUtils.isEmpty(aliasFor.value())) {
                        return targetMethodName.equals(annotationMethodName);
                    }
                    return false;
                }
                return false;
            }).collect(Collectors.toList());
            if (aliasForMethodList.isEmpty()) {
                Object attributeValue = this.getAttributeValue(mergedAnnotationElement.getMergedAnnotationClassList(), method);
                if (attributeValue == null) continue;
                return attributeValue;
            }
            if (aliasForMethodList.size() != 1) {
                RuntimeExceptionFactory.of("choose value  " + targetMethodName + " from the annotation of " + mergedAnnotationElement.getElement() + " has more same method of " + aliasForMethodList.stream().map(Method::getName).collect(Collectors.joining(",")));
                continue;
            }
            Method targetMethod = (Method)aliasForMethodList.get(0);
            AnnotatedElement element = mergedAnnotationElement.getElement();
            Annotation source = mergedAnnotationElement.getSource();
            return ReflexUtils.invokeDeclaredMethod((Object)source, targetMethod, new Object[0]);
        }
        return null;
    }

    private Object cloneArray(Object array) {
        if (array instanceof boolean[]) {
            boolean[] booleans = (boolean[])array;
            return booleans.clone();
        }
        if (array instanceof byte[]) {
            byte[] bytes = (byte[])array;
            return bytes.clone();
        }
        if (array instanceof char[]) {
            char[] chars = (char[])array;
            return chars.clone();
        }
        if (array instanceof double[]) {
            double[] doubles = (double[])array;
            return doubles.clone();
        }
        if (array instanceof float[]) {
            float[] floats = (float[])array;
            return floats.clone();
        }
        if (array instanceof int[]) {
            int[] ints = (int[])array;
            return ints.clone();
        }
        if (array instanceof long[]) {
            long[] longs = (long[])array;
            return longs.clone();
        }
        if (array instanceof short[]) {
            short[] shorts = (short[])array;
            return shorts.clone();
        }
        return ((Object[])array).clone();
    }

    static <A extends Annotation> A createProxy(MergedAnnotationElement annotationElement, Class<A> type) {
        ClassLoader classLoader = type.getClassLoader();
        Class[] interfaces = new Class[]{type};
        SynthesizedMergedAnnotationElementInvocationHandler<A> handler = new SynthesizedMergedAnnotationElementInvocationHandler<A>(annotationElement, type);
        return (A)((Annotation)Proxy.newProxyInstance(classLoader, interfaces, handler));
    }

    private static String getName(Class<?> clazz) {
        String canonicalName = clazz.getCanonicalName();
        return canonicalName != null ? canonicalName : clazz.getName();
    }
}

