/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.core.annotation;

import java.util.Arrays;
import org.wu.framework.core.annotation.AnnotationFilter;
import org.wu.framework.core.exception.AssertFactory;

final class PackagesAnnotationFilter
implements AnnotationFilter {
    private final String[] prefixes;
    private final int hashCode;

    PackagesAnnotationFilter(String ... packages) {
        AssertFactory.notNull(packages, "Packages array must not be null");
        this.prefixes = new String[packages.length];
        for (int i = 0; i < packages.length; ++i) {
            String pkg = packages[i];
            AssertFactory.hasText(pkg, "Packages array must not have empty elements");
            this.prefixes[i] = pkg + ".";
        }
        Arrays.sort(this.prefixes);
        this.hashCode = Arrays.hashCode(this.prefixes);
    }

    @Override
    public boolean matches(String annotationType) {
        for (String prefix : this.prefixes) {
            if (!annotationType.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        return Arrays.equals(this.prefixes, ((PackagesAnnotationFilter)other).prefixes);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "Packages annotation filter: " + String.join((CharSequence)",", this.prefixes);
    }
}

