/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.wu.framework.core.annotation.AnnotationFilter;
import org.wu.framework.core.annotation.MergedAnnotationElement;
import org.wu.framework.core.utils.ObjectUtils;

public class AnnotationsScanner {
    public static ConcurrentHashMap<AnnotatedElement, MergedAnnotationElement> cacheAnnotatedElement = new ConcurrentHashMap(128);
    public static LinkedHashSet<AnnotatedElement> cacheAnnotatedElementList = new LinkedHashSet();

    public static MergedAnnotationElement scan(AnnotatedElement annotatedElement) {
        if (cacheAnnotatedElement.containsKey(annotatedElement)) {
            return cacheAnnotatedElement.get(annotatedElement);
        }
        MergedAnnotationElement mergedAnnotationElement = null;
        if (annotatedElement instanceof Class) {
            Class clazz = (Class)annotatedElement;
            mergedAnnotationElement = clazz.isAnnotation() ? AnnotationsScanner.scanAnnotation0(clazz) : AnnotationsScanner.scanClass(clazz);
        } else if (annotatedElement instanceof Method) {
            Method method = (Method)annotatedElement;
            mergedAnnotationElement = AnnotationsScanner.scanMethod(method);
        } else if (annotatedElement instanceof Field) {
            Field field = (Field)annotatedElement;
            mergedAnnotationElement = AnnotationsScanner.scanField(field);
        } else {
            mergedAnnotationElement = AnnotationsScanner.scanElement(annotatedElement);
        }
        if (mergedAnnotationElement != null) {
            cacheAnnotatedElement.put(annotatedElement, mergedAnnotationElement);
        }
        return mergedAnnotationElement;
    }

    private static MergedAnnotationElement scanField(Field field) {
        MergedAnnotationElement mergedAnnotationElement = new MergedAnnotationElement();
        mergedAnnotationElement.setElement(field);
        List<MergedAnnotationElement> mergedAnnotationElementList = Arrays.stream(field.getAnnotations()).map(AnnotationsScanner::scanAnnotation).collect(Collectors.toList());
        mergedAnnotationElement.setMergedAnnotationClassList(mergedAnnotationElementList);
        return mergedAnnotationElement;
    }

    public static MergedAnnotationElement scanAnnotation(Annotation annotation) {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        MergedAnnotationElement mergedAnnotationElement = AnnotationsScanner.scanAnnotation0(annotationType);
        mergedAnnotationElement.setSource(annotation);
        return mergedAnnotationElement;
    }

    private static MergedAnnotationElement scanAnnotation0(Class<? extends Annotation> annotationType) {
        MergedAnnotationElement mergedAnnotationElement = new MergedAnnotationElement();
        ArrayList<MergedAnnotationElement> mergedAnnotationElementList = new ArrayList<MergedAnnotationElement>(Arrays.stream(annotationType.getAnnotations()).filter(annotation -> !annotation.annotationType().equals(annotationType)).filter(annotation1 -> !AnnotationFilter.PLAIN.matches(annotation1.annotationType())).map(AnnotationsScanner::scanAnnotation).filter(Objects::nonNull).collect(Collectors.toList()));
        if (Arrays.stream(annotationType.getAnnotations()).anyMatch(annotation -> annotation.annotationType().equals(annotationType))) {
            mergedAnnotationElementList.add(mergedAnnotationElement);
        }
        mergedAnnotationElement.setElement(annotationType);
        List<Method> methods = Arrays.stream(annotationType.getMethods()).collect(Collectors.toList());
        mergedAnnotationElement.setAnnotationMethodList(methods);
        List methodAnnotationClasses = methods.stream().map(AnnotationsScanner::scanMethod).filter(Objects::nonNull).collect(Collectors.toList());
        mergedAnnotationElementList.addAll(methodAnnotationClasses);
        mergedAnnotationElement.setMergedAnnotationClassList(mergedAnnotationElementList);
        return mergedAnnotationElement;
    }

    private static MergedAnnotationElement scanElement(AnnotatedElement annotatedElement) {
        return null;
    }

    private static MergedAnnotationElement scanMethod(Method method) {
        MergedAnnotationElement mergedAnnotationElement = new MergedAnnotationElement();
        List<MergedAnnotationElement> mergedAnnotationElementList = Arrays.stream(method.getAnnotations()).filter(annotation1 -> !AnnotationFilter.PLAIN.matches(annotation1.annotationType())).map(AnnotationsScanner::scanAnnotation).collect(Collectors.toList());
        if (ObjectUtils.isEmpty(mergedAnnotationElementList)) {
            return null;
        }
        mergedAnnotationElement.setElement(method);
        mergedAnnotationElement.setMergedAnnotationClassList(mergedAnnotationElementList);
        return mergedAnnotationElement;
    }

    private static MergedAnnotationElement scanClass(Class<?> clazz) {
        MergedAnnotationElement mergedAnnotationElement = new MergedAnnotationElement();
        mergedAnnotationElement.setElement(clazz);
        List<MergedAnnotationElement> mergedAnnotationElementList = Arrays.stream(clazz.getAnnotations()).map(AnnotationsScanner::scanAnnotation).collect(Collectors.toList());
        mergedAnnotationElement.setMergedAnnotationClassList(mergedAnnotationElementList);
        return mergedAnnotationElement;
    }

    public static <A extends Annotation> boolean scanHasElementAnnotation(AnnotatedElement annotatedElement, Class<A> annotation) {
        A elementAnnotation = annotatedElement.getAnnotation(annotation);
        if (elementAnnotation != null) {
            return true;
        }
        MergedAnnotationElement scan = AnnotationsScanner.scan(annotatedElement);
        return AnnotationsScanner.hasAnnotationInMergedAnnotationElement(scan, annotation);
    }

    protected static <A extends Annotation> boolean hasAnnotationInMergedAnnotationElement(MergedAnnotationElement mergedAnnotationElement, Class<A> annotation) {
        if (mergedAnnotationElement == null) {
            return false;
        }
        if (mergedAnnotationElement.getElement().equals(annotation)) {
            return true;
        }
        return mergedAnnotationElement.getMergedAnnotationClassList().stream().anyMatch(a -> AnnotationsScanner.hasAnnotationInMergedAnnotationElement(a, annotation));
    }
}

