/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.core;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ReflexUtils {
    public static Field findDeclaredField(Class<?> targetClass, String fieldName) {
        try {
            return targetClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T findDeclaredFieldBean(Object targetObject, String fieldName) {
        if (targetObject == null) {
            return null;
        }
        Class<?> targetClass = targetObject.getClass();
        Field declaredField = ReflexUtils.findDeclaredField(targetClass, fieldName);
        return ReflexUtils.findDeclaredFieldBean(targetObject, declaredField);
    }

    public static <T> T findDeclaredFieldBean(Object targetObject, Field declaredField) {
        if (targetObject == null) {
            return null;
        }
        try {
            declaredField.setAccessible(true);
            return (T)declaredField.get(targetObject);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static Field findField(Class<?> targetClass, String fieldName) {
        try {
            return targetClass.getField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static Method findDeclaredMethod(Class<?> targetClass, String method, Class<?> ... parameterTypes) {
        try {
            return targetClass.getDeclaredMethod(method, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static Boolean existsDeclaredMethod(Class<?> targetClass, String method, Class<?> ... parameterTypes) {
        try {
            targetClass.getDeclaredMethod(method, parameterTypes);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public static Method findMethod(Class<?> targetClass, String method, Class<?> ... parameterTypes) {
        try {
            return targetClass.getMethod(method, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object invokeDeclaredField(Object bean, String filedName) {
        if (bean == null) {
            return null;
        }
        if (bean instanceof Map) {
            return ((Map)bean).get(filedName);
        }
        Field declaredField = ReflexUtils.findDeclaredField(bean.getClass(), filedName);
        return ReflexUtils.invokeDeclaredField(bean, declaredField);
    }

    public static Object invokeDeclaredField(Object bean, Field declaredField) {
        if (bean == null) {
            return null;
        }
        Object invoke = null;
        try {
            declaredField.setAccessible(true);
            invoke = declaredField.get(bean);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return invoke;
    }

    public static Map<?, ?> invokeDeclaredFieldWithMap(Object bean, String filedName) {
        Object invokeDeclaredField = ReflexUtils.invokeDeclaredField(bean, filedName);
        if (invokeDeclaredField == null) {
            return null;
        }
        if (invokeDeclaredField instanceof Map) {
            return (Map)invokeDeclaredField;
        }
        throw new RuntimeException("\u83b7\u53d6\u5bf9\u8c61\u4e0d\u662fmap\u5bf9\u8c61:" + invokeDeclaredField.getClass().getName());
    }

    public static Object invokeDeclaredFieldWithDeep(Object bean, String filedName) {
        Object fieldValue = bean;
        for (String propName : filedName.split("\\.")) {
            Object invokeDeclaredField = ReflexUtils.invokeDeclaredField(fieldValue, propName);
            fieldValue = invokeDeclaredField == null ? null : invokeDeclaredField;
        }
        return fieldValue;
    }

    public static Object invokeDeclaredMethod(Object bean, Method declaredMethod, Object ... parameter) {
        if (bean == null) {
            return null;
        }
        Object invoke = null;
        try {
            invoke = declaredMethod.invoke(bean, parameter);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return invoke;
    }

    public static Object invokeDeclaredMethod(Object bean, String method, Object ... parameter) {
        if (bean == null) {
            return null;
        }
        Class<?> targetClass = bean.getClass();
        Method declaredMethod = ReflexUtils.findDeclaredMethod(targetClass, method, new Class[0]);
        return ReflexUtils.invokeDeclaredMethod(bean, declaredMethod, parameter);
    }

    public static <T> T newInstance(Class<T> t) {
        if (t == null) {
            throw new IllegalArgumentException("class is null ");
        }
        try {
            return t.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<Method> findConcreteMethodsOnInterfaces(Class<?> clazz) {
        ArrayList<Method> result = null;
        for (Class<?> ifc : clazz.getInterfaces()) {
            for (Method ifcMethod : ifc.getMethods()) {
                if (Modifier.isAbstract(ifcMethod.getModifiers())) continue;
                if (result == null) {
                    result = new ArrayList<Method>();
                }
                result.add(ifcMethod);
            }
        }
        return result;
    }

    public static boolean isEqualsMethod(Method method) {
        if (method == null) {
            return false;
        }
        if (method.getParameterCount() != 1) {
            return false;
        }
        if (!method.getName().equals("equals")) {
            return false;
        }
        return method.getParameterTypes()[0] == Object.class;
    }

    public static boolean isHashCodeMethod(Method method) {
        return method != null && method.getParameterCount() == 0 && method.getName().equals("hashCode");
    }

    public static boolean isToStringMethod(Method method) {
        return method != null && method.getParameterCount() == 0 && method.getName().equals("toString");
    }

    public static boolean isObjectMethod(Method method) {
        return method != null && (method.getDeclaringClass() == Object.class || ReflexUtils.isEqualsMethod(method) || ReflexUtils.isHashCodeMethod(method) || ReflexUtils.isToStringMethod(method));
    }
}

