/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.core.utils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

public class LazyProxyUtils {
    public static boolean isProxy(Object obj) {
        return Proxy.isProxyClass(obj.getClass());
    }

    public static boolean isJdkProxy(Object obj) {
        return LazyProxyUtils.isProxy(obj) && obj.getClass().getName().startsWith("$Proxy");
    }

    public static boolean hasInvocationHandler(Object proxy, Class<?> handlerType) {
        if (!LazyProxyUtils.isProxy(proxy)) {
            return false;
        }
        try {
            InvocationHandler h = Proxy.getInvocationHandler(proxy);
            return handlerType.isInstance(h);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

