/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.core.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalTimeSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

public class JsonUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static String toJsonString(Object value) {
        String json;
        try {
            json = OBJECT_MAPPER.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("\u8f6c\u6362\u4e3aJson\u5b57\u7b26\u4e32\u51fa\u9519:%s" + (Object)((Object)e));
        }
        return json;
    }

    public static <T> T parseObject(String fromValue, Class<T> toValueType) {
        Object toValue;
        try {
            toValue = OBJECT_MAPPER.readValue(fromValue, toValueType);
        }
        catch (IOException e) {
            throw new RuntimeException("\u8f6c\u6362\u4e3aJson\u5b57\u7b26\u4e32\u51fa\u9519:%s" + e);
        }
        return (T)toValue;
    }

    public static <T> T parseObject(InputStream src, Class<T> valueType) {
        Object toValue;
        try {
            toValue = OBJECT_MAPPER.readValue(src, valueType);
        }
        catch (IOException e) {
            throw new RuntimeException("\u8f6c\u6362\u4e3aJson\u5b57\u7b26\u4e32\u51fa\u9519:%s" + e);
        }
        return (T)toValue;
    }

    public static <T> T parseObject(byte[] src, Class<T> valueType) {
        Object toValue;
        try {
            toValue = OBJECT_MAPPER.readValue(src, valueType);
        }
        catch (IOException e) {
            throw new RuntimeException("\u8f6c\u6362\u4e3aJson\u5b57\u7b26\u4e32\u51fa\u9519:%s" + e);
        }
        return (T)toValue;
    }

    public static <T> T parseObject(String fromValue, TypeReference<T> toValueType) {
        Object toValue;
        try {
            toValue = OBJECT_MAPPER.readValue(fromValue, toValueType);
        }
        catch (IOException e) {
            throw new RuntimeException("\u8f6c\u6362\u4e3aJson\u5b57\u7b26\u4e32\u51fa\u9519:%s" + e);
        }
        return (T)toValue;
    }

    public static <T> T convertObject(Object fromValue, Class<T> toValueType) {
        return (T)OBJECT_MAPPER.convertValue(fromValue, toValueType);
    }

    static {
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        javaTimeModule.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        javaTimeModule.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        javaTimeModule.addSerializer(LocalTime.class, (JsonSerializer)new LocalTimeSerializer(DateTimeFormatter.ofPattern("HH:mm:ss")));
        OBJECT_MAPPER.registerModule((Module)javaTimeModule);
    }
}

