/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.core.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.wu.framework.core.exception.AssertFactory;
import org.wu.framework.core.utils.ObjectUtils;

public class FileUtil {
    public static File createUserDirFile(String fileName) {
        String path = System.getProperty("user.dir");
        File file = new File(ObjectUtils.isEmpty(path) ? fileName : path + File.separator + fileName);
        File parent = file.getParentFile();
        System.out.println("\u6587\u4ef6\u6240\u5728\u76ee\u5f55:" + file.getAbsolutePath());
        if (!parent.exists()) {
            parent.mkdirs();
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    public static File createFile(String path, String fileName) {
        File file = new File(ObjectUtils.isEmpty(path) ? fileName : path + File.separator + fileName);
        File parent = file.getParentFile();
        System.out.println("\u6587\u4ef6\u6240\u5728\u76ee\u5f55:" + file.getAbsolutePath());
        if (!parent.exists()) {
            parent.mkdirs();
        }
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    public static BufferedWriter createUserDirFileBufferedWriter(String fileName) {
        try {
            return new BufferedWriter(new FileWriter(FileUtil.createUserDirFile(fileName)));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static BufferedWriter createFileBufferedWriter(File file) {
        try {
            return new BufferedWriter(new FileWriter(file));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static BufferedWriter createFileBufferedWriter(String path, String fileName) {
        File file = FileUtil.createFile(path, fileName);
        return FileUtil.createFileBufferedWriter(file);
    }

    public static BufferedWriter createFileBufferedWriter(String path, String prefix, String suffix, String fileName) {
        return FileUtil.createFileBufferedWriter(path, prefix + fileName + suffix);
    }

    public static <T> String readLocalClassFolder(Class<T> localClass) {
        AssertFactory.notNull(localClass, "localClass \u4e0d\u80fd\u4e3a\u7a7a");
        URL resource = localClass.getResource("/");
        String resourceFilePrefix = resource.getFile();
        return resourceFilePrefix;
    }

    public static <T> String readLocalSrcMainClassFolder(Class<T> localClass) {
        AssertFactory.notNull(localClass, "localClass \u4e0d\u80fd\u4e3a\u7a7a");
        URL resource = localClass.getResource("/");
        String resourceFilePrefix = resource.getFile();
        return resourceFilePrefix.replace(File.separator + "target" + File.separator + "classes" + File.separator, File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator);
    }

    public static <T> String readLocalSrcMainClassPath(Class<T> localClass) {
        AssertFactory.notNull(localClass, "localClass \u4e0d\u80fd\u4e3a\u7a7a");
        URL resource = localClass.getResource("/");
        String resourceFilePrefix = resource.getFile();
        String name = localClass.getName();
        String relativePath = name.replace(".", File.separator);
        return resourceFilePrefix.replace(File.separator + "target" + File.separator + "classes" + File.separator, File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator).replace(File.separator + "target" + File.separator + "test-classes" + File.separator, File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator) + relativePath + ".java";
    }

    public static String readFileContent(String fileName) {
        return String.join((CharSequence)"\n", FileUtil.readFileLineContent(fileName).values());
    }

    public static String readFileContent0(File file) {
        return String.join((CharSequence)"\n", FileUtil.readFileLineContent(file).values());
    }

    public static String readFileContent(BufferedReader bufferedReader) {
        return String.join((CharSequence)"\n", FileUtil.readFileLineContent(bufferedReader).values());
    }

    public static Map<Integer, String> readFileLineContent(String fileName) {
        File file = new File(fileName);
        return FileUtil.readFileLineContent(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Integer, String> readFileLineContent(File file) {
        BufferedReader reader = null;
        Map<Integer, String> fileLineContentMap = new LinkedHashMap<Integer, String>();
        try {
            reader = new BufferedReader(new FileReader(file));
            Map<Integer, String> map = fileLineContentMap = FileUtil.readFileLineContent(reader);
            return map;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioException) {
                    ioException.printStackTrace();
                }
            }
        }
        return fileLineContentMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Integer, String> readFileLineContent(BufferedReader reader) {
        LinkedHashMap<Integer, String> fileLineContentMap = new LinkedHashMap<Integer, String>();
        try {
            Serializable serializable;
            String tempStr;
            Integer line = 1;
            while ((tempStr = reader.readLine()) != null) {
                fileLineContentMap.put(line, tempStr);
                serializable = line;
                Integer n = line = Integer.valueOf(line + 1);
            }
            reader.close();
            serializable = fileLineContentMap;
            return serializable;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioException) {
                    ioException.printStackTrace();
                }
            }
        }
        return fileLineContentMap;
    }

    public static BufferedWriter addFileContent(File file) throws IOException {
        String fileContent = FileUtil.readFileContent0(file);
        BufferedWriter bufferedWriter = FileUtil.createFileBufferedWriter(file);
        bufferedWriter.write(fileContent);
        return bufferedWriter;
    }

    public static BufferedWriter addFileContent(String fileName) throws IOException {
        String fileContent = FileUtil.readFileContent(fileName);
        BufferedWriter bufferedWriter = FileUtil.createFileBufferedWriter(null, fileName);
        bufferedWriter.write(fileContent);
        return bufferedWriter;
    }

    public static void modifyLineWithChart(String path, String chart, Map<String, String> replaceMap) throws IOException {
        AssertFactory.notNull(path, "path \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        File file = new File(path);
        FileUtil.modifyLineWithChart(file, chart, replaceMap);
    }

    public static void modifyLineWithChart(File file, String chart, Map<String, String> replaceMap) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        File tempFile = new File(file.getPath() + ".temp");
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(tempFile));
        boolean hasChange = false;
        Set<String> oldChars = replaceMap.keySet();
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (!line.contains(chart)) {
                for (String oldChar : oldChars) {
                    if (!line.contains(oldChar)) continue;
                    String newChar = replaceMap.get(oldChar);
                    line = line.replace(oldChar, newChar);
                    hasChange = true;
                }
                bufferedWriter.write(line);
                bufferedWriter.newLine();
                continue;
            }
            hasChange = true;
        }
        bufferedWriter.close();
        reader.close();
        if (!hasChange) {
            tempFile.deleteOnExit();
        }
    }

    public static void aggregateAllFilesOnFolder(String folderPath, boolean depth, String aggregateSuffix) throws IOException {
        AssertFactory.notNull(aggregateSuffix, "\u6587\u4ef6\u805a\u5408\u6587\u4ef6\u540d\u79f0\u540e\u7f00 \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        BufferedWriter bufferedWriter = FileUtil.aggregateAllFilesOnFolder(folderPath, depth, null, aggregateSuffix);
        bufferedWriter.close();
    }

    public static BufferedWriter aggregateAllFilesOnFolder(String folderPath, boolean depth, BufferedWriter bufferedWriter, String aggregateSuffix) throws IOException {
        AssertFactory.notNull(folderPath, "\u6587\u4ef6\u5939\u5730\u5740 \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        File folderFile = new File(folderPath);
        if (!folderFile.exists()) {
            throw new RuntimeException("\u6587\u4ef6\u5939\u5730\u5740\u4e0d\u5b58\u5728");
        }
        if (folderFile.isDirectory()) {
            if (ObjectUtils.isEmpty(bufferedWriter)) {
                File tempFile = new File(folderFile.getParent() + File.separator + folderFile.getName() + "." + aggregateSuffix);
                bufferedWriter = new BufferedWriter(new FileWriter(tempFile));
            }
            List fileList = Arrays.stream((Object[])Objects.requireNonNull(folderFile.listFiles())).sorted().collect(Collectors.toList());
            for (File file : fileList) {
                System.out.println("\u8bfb\u53d6\u6587\u4ef6\u540d\u79f0:" + file.getName());
                if (file.isDirectory()) {
                    if (!depth) continue;
                    FileUtil.aggregateAllFilesOnFolder(file.getPath(), true, bufferedWriter, aggregateSuffix);
                    continue;
                }
                BufferedReader reader = new BufferedReader(new FileReader(file));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    bufferedWriter.write(line);
                    bufferedWriter.newLine();
                }
                reader.close();
            }
        } else {
            if (ObjectUtils.isEmpty(bufferedWriter)) {
                File parentFile = folderFile.getParentFile();
                File tempFile = new File(parentFile.getParent() + File.separator + parentFile.getName() + "." + aggregateSuffix);
                bufferedWriter = new BufferedWriter(new FileWriter(tempFile));
            }
            FileUtil.aggregateAllFilesOnFolder(folderFile.getParent(), depth, bufferedWriter, aggregateSuffix);
        }
        return bufferedWriter;
    }

    public static void aggregateFiles(List<File> fileList, File aggregateFile) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(aggregateFile));
        for (File file : fileList) {
            if (file == null) continue;
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = null;
            while ((line = reader.readLine()) != null) {
                bufferedWriter.write(line);
                bufferedWriter.newLine();
            }
            reader.close();
        }
        bufferedWriter.close();
    }

    protected static HashSet<File> readFilesOnFolder(String folderPath, boolean depth, String fileSuffix, HashSet<File> fileList) throws IOException {
        File folderFile;
        AssertFactory.notNull(folderPath, "\u6587\u4ef6\u5939\u5730\u5740 \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        if (ObjectUtils.isEmpty(fileList)) {
            fileList = new HashSet();
        }
        if ((folderFile = new File(folderPath)).isDirectory()) {
            List folderFileList = Arrays.stream((Object[])Objects.requireNonNull(folderFile.listFiles())).sorted().collect(Collectors.toList());
            for (File file : folderFileList) {
                if (file.isDirectory() && depth) {
                    HashSet<File> files = FileUtil.readFilesOnFolder(file.getPath(), true, fileSuffix, fileList);
                    fileList.addAll(files);
                    continue;
                }
                if (!file.getName().endsWith(fileSuffix)) continue;
                fileList.add(file);
            }
        } else if (folderFile.getName().endsWith(fileSuffix)) {
            fileList.add(folderFile);
        }
        return fileList;
    }

    public static HashSet<File> readFilesOnFolder(String folderPath, boolean depth, String fileSuffix) throws IOException {
        return FileUtil.readFilesOnFolder(folderPath, depth, fileSuffix, null);
    }

    public static void main(String[] args) throws IOException {
        FileUtil.modifyLineWithChart("/Users/wujiawei/IdeaProjects/middleground/middleground-tenant-free/sql/crm.sql", "DROP TABLE IF EXISTS", (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("CREATE TABLE", "CREATE TABLE IF NOT EXISTS");
            }
        });
        FileUtil.aggregateAllFilesOnFolder("/Users/wujiawei/IdeaProjects/middleground/middleground-tenant-free/sql/middleground", true, "sql");
    }
}

