/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.core.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.util.Arrays;

public class BinHexSwitchUtil {
    public static final int BUFFSIZE_1024 = 1024;

    public static String bytesToHexString(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (byte b : bytes) {
            int temp = b & 0xFF;
            String tempStr = Integer.toHexString(temp);
            if (tempStr.length() == 1) {
                result.append("0").append(tempStr);
                continue;
            }
            result.append(tempStr);
        }
        return result.toString();
    }

    public static String bytesToHexSql(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        StringBuilder result = new StringBuilder("0x");
        for (byte b : bytes) {
            int temp = b & 0xFF;
            String tempStr = Integer.toHexString(temp);
            if (tempStr.length() == 1) {
                result.append("0").append(tempStr);
                continue;
            }
            result.append(tempStr);
        }
        return result.toString();
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.length() == 0) {
            return null;
        }
        byte[] result = new byte[hexString.length() / 2];
        int i = 0;
        int foot = 0;
        while (i < hexString.length()) {
            String temp = hexString.substring(i, i + 2);
            result[foot] = (byte)Integer.parseInt(temp, 16);
            i += 2;
            ++foot;
        }
        return result;
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        BufferedInputStream bufin = new BufferedInputStream(in);
        int buffSize = 1024;
        ByteArrayOutputStream out = new ByteArrayOutputStream(buffSize);
        byte[] temp = new byte[buffSize];
        int size = 0;
        while ((size = bufin.read(temp)) != -1) {
            out.write(temp, 0, size);
        }
        bufin.close();
        byte[] content = out.toByteArray();
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] blobToBytes(Blob blob) {
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(blob.getBinaryStream());
            byte[] bytes = new byte[(int)blob.length()];
            int len = bytes.length;
            int read = 0;
            for (int offset = 0; offset < len && (read = is.read(bytes, offset, len - offset)) >= 0; offset += read) {
            }
            byte[] byArray = bytes;
            return byArray;
        }
        catch (Exception e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                is.close();
                is = null;
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    public static void main(String[] args) {
        String value = "a2\tcdefghijklmnxyz";
        System.out.println("value 2\u8fdb\u5236:" + Arrays.toString(value.getBytes()));
        String hexStr = BinHexSwitchUtil.bytesToHexString(value.getBytes());
        System.out.println("value 16\u8fdb\u5236\uff1a" + hexStr);
        System.out.println("value\u8f6c\u56de\u4e8c\u8fdb\u5236\uff1a" + Arrays.toString(BinHexSwitchUtil.hexStringToBytes(hexStr)));
        System.out.println("value\u8f6c\u56de\u4e8c\u8fdb\u5236\uff1a" + new String(BinHexSwitchUtil.hexStringToBytes(hexStr)));
        System.out.println((byte)Integer.parseInt("-129"));
    }
}

