/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.core.stereotype.analyze;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.wu.framework.core.CamelAndUnderLineConverter;
import org.wu.framework.core.annotation.AnnotatedElementUtils;
import org.wu.framework.core.stereotype.LayerField;
import org.wu.framework.core.stereotype.analyze.AnalyzeField;
import org.wu.framework.core.stereotype.analyze.AnalyzeParameter;
import org.wu.framework.core.stereotype.analyze.LayerAnalyze;
import org.wu.framework.core.utils.ObjectUtils;

public class LayerFieldAnalyze
implements LayerAnalyze {
    @Override
    public boolean supportParameter(AnalyzeParameter analyzeParameter) {
        return true;
    }

    public List<AnalyzeField> analyze(AnalyzeParameter analyzeParameter) {
        ArrayList<AnalyzeField> analyzeFieldList = new ArrayList<AnalyzeField>();
        for (Field field : analyzeParameter.getClazz().getDeclaredFields()) {
            LayerField layerField = AnnotatedElementUtils.findMergedAnnotation(field, LayerField.class);
            if (!ObjectUtils.isEmpty(layerField) && !layerField.exist()) continue;
            AnalyzeField analyzeField = AnalyzeField.builder().fieldName(field.getName()).convertedFieldName(CamelAndUnderLineConverter.humpToLine2(field.getName())).build();
            if (!ObjectUtils.isEmpty(layerField)) {
                analyzeField.setFieldIndexType(layerField.indexType());
            }
            analyzeFieldList.add(analyzeField);
        }
        return analyzeFieldList;
    }
}

