/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.core.proxy;

import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wu.framework.core.proxy.ProxyRetryInvocationHandler;

public abstract class AbstractProxyRetryInvocationHandler
implements ProxyRetryInvocationHandler {
    private final Logger log = LoggerFactory.getLogger(AbstractProxyRetryInvocationHandler.class);

    @Override
    public Object retryInvoke(Object proxy, Method method, Object[] args, int retryTime, Throwable throwable, boolean hasRetry) throws Throwable {
        try {
            Object invoke = this.doRetryInvoke(proxy, method, args, retryTime, throwable, hasRetry);
            this.afterRetryInvoke(hasRetry);
            return invoke;
        }
        catch (Throwable throwable1) {
            if (retryTime > 0) {
                return this.retryInvoke(proxy, method, args, retryTime - 1, throwable, true);
            }
            if (throwable == null) {
                throwable = throwable1;
            }
            this.log.warn("\u6570\u636e\u5e93\u6cbb\u6108\u5931\u8d25:{}", throwable);
            throw throwable;
        }
    }

    public abstract Object doRetryInvoke(Object var1, Method var2, Object[] var3, int var4, Throwable var5, boolean var6) throws Throwable;

    public abstract void afterRetryInvoke(boolean var1);
}

