/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.core.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.wu.framework.core.io.ScriptResource;

public class FileSystemScriptResource
implements ScriptResource {
    private final String path;
    private final File file;
    private final Path filePath;

    public FileSystemScriptResource(String path) {
        this.path = path;
        this.file = new File(path);
        this.filePath = this.file.toPath();
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            return Files.newInputStream(this.filePath, new OpenOption[0]);
        }
        catch (NoSuchFileException ex) {
            throw new FileNotFoundException(ex.getMessage());
        }
    }
}

