/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.core;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wu.framework.core.utils.ObjectUtils;

public class CamelAndUnderLineConverter {
    private static final Pattern linePattern = Pattern.compile("_(\\w)");
    private static final Pattern humpPattern = Pattern.compile("[A-Z]");

    @Deprecated
    public static String lineToHump(String str) {
        Matcher matcher = linePattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String lineToHumpField(String str) {
        Matcher matcher = linePattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String lineToHumpClass(String str) {
        Matcher matcher = linePattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, matcher.group(1).toUpperCase());
        }
        matcher.appendTail(sb);
        return CamelAndUnderLineConverter.capitalizeFirstLetter(sb.toString());
    }

    public static String humpToLine(String hump) {
        return hump.replaceAll("[A-Z]", "_$0").toLowerCase();
    }

    public static String humpToLine2(String hump) {
        return CamelAndUnderLineConverter.humpTo2(hump, "_");
    }

    public static String humpToMidLine2(String hump) {
        return CamelAndUnderLineConverter.humpTo2(hump, "-");
    }

    public static String humpTo2(String hump, String character) {
        char[] chars = new char[1];
        if (ObjectUtils.isEmpty(hump)) {
            return hump;
        }
        chars[0] = hump.charAt(0);
        String temp = new String(chars);
        try {
            hump = hump.replaceFirst(temp, temp.toLowerCase());
        }
        catch (Exception e) {
            System.out.println(hump);
            e.printStackTrace();
        }
        Matcher matcher = humpPattern.matcher(hump);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, character + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static List<String> humpToArray(String hump) {
        char[] chars = new char[]{hump.charAt(0)};
        String temp = new String(chars);
        try {
            hump = hump.replaceFirst(temp, temp.toLowerCase());
        }
        catch (Exception e) {
            System.out.println(hump);
            e.printStackTrace();
        }
        Matcher matcher = humpPattern.matcher(hump);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return Arrays.asList(sb.toString().split("_"));
    }

    public static String capitalizeFirstLetter(String name) {
        if (ObjectUtils.isEmpty(name)) {
            return name;
        }
        if (CamelAndUnderLineConverter.isUppercase(name)) {
            return name;
        }
        char[] cs = name.toCharArray();
        if (cs.length == 0) {
            return String.valueOf(cs);
        }
        cs[0] = (char)(cs[0] - 32);
        return String.valueOf(cs);
    }

    public static boolean isUppercase(String name) {
        char c = name.charAt(0);
        return Character.isUpperCase(c);
    }

    public static String lowercaseFirstLetter(String name) {
        if (!CamelAndUnderLineConverter.isUppercase(name)) {
            return name;
        }
        char[] cs = name.toCharArray();
        if (cs.length == 0) {
            return String.valueOf(cs);
        }
        cs[0] = (char)(cs[0] + 32);
        return String.valueOf(cs);
    }

    public static void main(String[] args) {
        String lineToHump = CamelAndUnderLineConverter.lineToHump("table_Name");
        System.out.println(lineToHump);
        System.out.println(CamelAndUnderLineConverter.humpToLine(lineToHump));
        System.out.println(CamelAndUnderLineConverter.humpToLine2("ParentNoLeader"));
        System.out.println(CamelAndUnderLineConverter.lowercaseFirstLetter("UserName"));
    }

    public static String methodToField(String name) {
        if (name.startsWith("is")) {
            name = name.substring(2);
        } else if (name.startsWith("get") || name.startsWith("set")) {
            name = name.substring(3);
        } else {
            throw new RuntimeException("Error parsing property name '" + name + "'.  Didn't start with 'is', 'get' or 'set'.");
        }
        if (name.length() == 1 || name.length() > 1 && !Character.isUpperCase(name.charAt(1))) {
            name = name.substring(0, 1).toLowerCase(Locale.ENGLISH) + name.substring(1);
        }
        return name;
    }

    public static boolean isField(String name) {
        return CamelAndUnderLineConverter.isGetter(name) || CamelAndUnderLineConverter.isSetter(name);
    }

    public static boolean isGetter(String name) {
        return name.startsWith("get") && name.length() > 3 || name.startsWith("is") && name.length() > 2;
    }

    public static boolean isSetter(String name) {
        return name.startsWith("set") && name.length() > 3;
    }
}

