/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.bean.definition;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.wu.framework.bean.Injecting;
import org.wu.framework.bean.definition.BeanDefinition;
import org.wu.framework.bean.definition.GeneralBeanDefinition;

public class DefineClassCacheFactory {
    private static final LinkedHashSet<Class<?>> beanClasses = new LinkedHashSet();
    private static final ConcurrentHashMap<Class<?>, BeanDefinition> BEAN_DEFINITION_CONCURRENT_HASH_MAP = new ConcurrentHashMap();

    public void cache(Class<?> clazz) {
        beanClasses.add(clazz);
    }

    public void cache(Collection<Class<?>> clazzList) {
        beanClasses.addAll(clazzList);
    }

    public static BeanDefinition cacheBeanDefinition(Class<?> clazz) {
        if (BEAN_DEFINITION_CONCURRENT_HASH_MAP.containsKey(clazz)) {
            return BEAN_DEFINITION_CONCURRENT_HASH_MAP.get(clazz);
        }
        Constructor<?>[] constructors = clazz.getConstructors();
        if (constructors.length > 1) {
            throw new IllegalArgumentException("the bean of " + clazz.getName() + " must has on public  Constructor  but found " + constructors.length);
        }
        Constructor<?> constructor = constructors[0];
        GeneralBeanDefinition generalBeanDefinition = new GeneralBeanDefinition();
        generalBeanDefinition.setConstructor(constructor);
        generalBeanDefinition.setParameterTypes(constructor.getParameterTypes());
        List<Field> injectingFields = DefineClassCacheFactory.injectingFields(clazz);
        generalBeanDefinition.setInjectingFields(injectingFields);
        List<Method> injectingMethods = DefineClassCacheFactory.injectingMethods(clazz);
        generalBeanDefinition.setInjectingMethods(injectingMethods);
        List<Method> initMethods = DefineClassCacheFactory.initMethods(clazz);
        generalBeanDefinition.setInitMethods(initMethods);
        BEAN_DEFINITION_CONCURRENT_HASH_MAP.put(clazz, generalBeanDefinition);
        return generalBeanDefinition;
    }

    public static List<Field> injectingFields(Class<?> clazz) {
        ArrayList<Field> injectingFields = new ArrayList<Field>();
        Field[] declaredFields = clazz.getDeclaredFields();
        Field[] fields = clazz.getFields();
        Field[] fieldsArray = new Field[declaredFields.length + fields.length];
        System.arraycopy(declaredFields, 0, fieldsArray, 0, declaredFields.length);
        System.arraycopy(fields, 0, fieldsArray, declaredFields.length, fields.length);
        for (Field field : fieldsArray) {
            boolean annotationPresent = field.isAnnotationPresent(Injecting.class);
            if (!annotationPresent) continue;
            injectingFields.add(field);
        }
        return injectingFields;
    }

    public static List<Method> injectingMethods(Class<?> clazz) {
        ArrayList<Method> injectingMethods = new ArrayList<Method>();
        Method[] declaredMethods = clazz.getDeclaredMethods();
        Method[] methods = clazz.getMethods();
        Method[] methodArray = new Method[declaredMethods.length + methods.length];
        System.arraycopy(declaredMethods, 0, methodArray, 0, declaredMethods.length);
        System.arraycopy(methods, 0, methodArray, declaredMethods.length, methods.length);
        for (Method method : methodArray) {
            boolean annotationPresent = method.isAnnotationPresent(Injecting.class);
            if (!annotationPresent) continue;
            injectingMethods.add(method);
        }
        return injectingMethods;
    }

    private static List<Method> initMethods(Class<?> clazz) {
        Method[] methods;
        ArrayList<Method> initMethods = new ArrayList<Method>();
        for (Method method : methods = clazz.getMethods()) {
            boolean annotationPresent = method.isAnnotationPresent(Injecting.class);
            if (!annotationPresent) continue;
            initMethods.add(method);
        }
        return initMethods;
    }
}

