/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.bean.factory;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.wu.framework.bean.definition.BeanDefinition;
import org.wu.framework.bean.definition.DefineClassCacheFactory;

public class BeanFactory {
    private static final ConcurrentHashMap<Class<?>, Object> INSTANCE_MAP = new ConcurrentHashMap();

    public static <T> T getInstance(Class<T> clazz) {
        if (INSTANCE_MAP.containsKey(clazz)) {
            return clazz.cast(INSTANCE_MAP.get(clazz));
        }
        return BeanFactory.getInstance0(clazz);
    }

    private static <T> T getInstance0(Class<T> clazz) {
        try {
            BeanDefinition beanDefinition = DefineClassCacheFactory.cacheBeanDefinition(clazz);
            Constructor<?> constructor = beanDefinition.getConstructor();
            Class<?>[] parameterTypes = beanDefinition.getParameterTypes();
            Object[] initArgs = new Object[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                initArgs[i] = BeanFactory.getInstance(parameterTypes[i]);
            }
            Object newInstance = constructor.newInstance(initArgs);
            List<Field> injectingFields = beanDefinition.getInjectingFields();
            for (Field injectingField : injectingFields) {
                injectingField.setAccessible(true);
                Class<?> injectingFieldType = injectingField.getType();
                Object injectingFieldInstance = BeanFactory.getInstance(injectingFieldType);
                injectingField.set(newInstance, injectingFieldInstance);
            }
            List<Method> injectingMethods = beanDefinition.getInjectingMethods();
            for (Method injectingMethod : injectingMethods) {
                Class<?>[] injectingMethodParameterTypes = injectingMethod.getParameterTypes();
                Object[] initInjectingMethodParameterArgs = new Object[injectingMethodParameterTypes.length];
                for (int i = 0; i < injectingMethodParameterTypes.length; ++i) {
                    initInjectingMethodParameterArgs[i] = BeanFactory.getInstance(injectingMethodParameterTypes[i]);
                }
                injectingMethod.invoke(newInstance, initInjectingMethodParameterArgs);
            }
            INSTANCE_MAP.put(clazz, newInstance);
            return clazz.cast(newInstance);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new IllegalArgumentException("Failed to create instance of  type " + clazz.getName(), e);
        }
    }
}

