/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.sql.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableEndpoint;
import org.wu.framework.lazy.orm.core.source.adapter.SourceFactory;
import org.wu.framework.lazy.orm.database.lambda.domain.Persistence;
import org.wu.framework.lazy.orm.database.lambda.stream.condition.part.Condition;
import org.wu.framework.lazy.orm.database.lambda.stream.condition.part.SqlPart;
import org.wu.framework.lazy.orm.database.sql.util.SqlColumnUtils;

public class SqlUtils {
    private static String errorMessageWithTable(String errorMessage) {
        if (errorMessage.startsWith("Table") && errorMessage.endsWith("doesn't exist")) {
            return errorMessage.replaceFirst("Table", "").replace("doesn't exist", "").replaceAll("'", "");
        }
        return null;
    }

    private static List<String> insertTable(String insertSql) {
        String[] sqlWords;
        ArrayList<String> tableNames = new ArrayList<String>();
        int hitNum = 0;
        for (String sqlWord : sqlWords = insertSql.replaceAll("`", "").replaceAll("\n", " ").split(" ")) {
            if (ObjectUtils.isEmpty((Object)sqlWord)) continue;
            if (sqlWord.equalsIgnoreCase("INSERT")) {
                ++hitNum;
                continue;
            }
            if (sqlWord.equalsIgnoreCase("INTO")) {
                ++hitNum;
                continue;
            }
            if (hitNum != 2) continue;
            tableNames.add(sqlWord);
            ++hitNum;
        }
        return tableNames;
    }

    private static List<String> updateTable(String updateSql) {
        String[] sqlWords;
        ArrayList<String> tableNames = new ArrayList<String>();
        int hitNum = 0;
        int hitIgnoreNum = 0;
        for (String sqlWord : sqlWords = updateSql.replaceAll("`", "").replaceAll("\n", " ").split(" ")) {
            if (ObjectUtils.isEmpty((Object)sqlWord)) continue;
            if (sqlWord.equalsIgnoreCase("ON")) {
                hitIgnoreNum = 1;
                continue;
            }
            if (hitIgnoreNum == 1 && sqlWord.equalsIgnoreCase("DUPLICATE")) {
                hitIgnoreNum = 2;
                continue;
            }
            if (hitIgnoreNum == 2 && sqlWord.equalsIgnoreCase("KEY")) {
                hitIgnoreNum = 3;
                continue;
            }
            if (hitIgnoreNum == 3 && sqlWord.equalsIgnoreCase("UPDATE")) {
                hitIgnoreNum = 0;
                continue;
            }
            if (sqlWord.equalsIgnoreCase("UPDATE")) {
                hitNum = 1;
                continue;
            }
            if (hitNum == 1) {
                tableNames.add(sqlWord);
                ++hitNum;
                continue;
            }
            if (hitNum == 2 && (sqlWord.equalsIgnoreCase(",") || sqlWord.contains(",")) && !sqlWord.contains("=")) {
                hitNum = 1;
                continue;
            }
            if (hitNum != 2 || !sqlWord.equalsIgnoreCase("JOIN")) continue;
            hitNum = 1;
        }
        return tableNames;
    }

    private static List<String> selectTable(String selectSql) {
        String[] sqlWords;
        ArrayList<String> tableNames = new ArrayList<String>();
        int hitNum = 0;
        for (String sqlWord : sqlWords = selectSql.replaceAll("`", "").replaceAll("\n", " ").split(" ")) {
            if (ObjectUtils.isEmpty((Object)sqlWord)) continue;
            if (sqlWord.equalsIgnoreCase("select")) {
                hitNum = 1;
                continue;
            }
            if (sqlWord.equalsIgnoreCase("from")) {
                hitNum = 2;
                continue;
            }
            if (hitNum == 2 && sqlWord.equalsIgnoreCase("(")) {
                hitNum = 0;
                continue;
            }
            if (hitNum == 2 && sqlWord.equalsIgnoreCase("(select")) {
                hitNum = 1;
                continue;
            }
            if (hitNum == 2) {
                tableNames.add(sqlWord);
                hitNum = 3;
                continue;
            }
            if (hitNum != 3 || !sqlWord.equalsIgnoreCase(",") && !sqlWord.equalsIgnoreCase("join")) continue;
            hitNum = 2;
        }
        return tableNames;
    }

    public static List<String> schema(String sql) {
        String[] sqlWords;
        ArrayList<String> schemas = new ArrayList<String>();
        int hitNum = 0;
        for (String sqlWord : sqlWords = sql.replaceAll("`", "").replaceAll("\n", " ").split(" ")) {
            if (ObjectUtils.isEmpty((Object)sqlWord)) continue;
            if (sqlWord.equalsIgnoreCase("from")) {
                hitNum = 2;
                continue;
            }
            if (sqlWord.equalsIgnoreCase("Unknown")) {
                hitNum = 1;
                continue;
            }
            if (hitNum == 1 && sqlWord.equalsIgnoreCase("database")) {
                hitNum = 2;
                continue;
            }
            if (hitNum != 2) continue;
            if (sqlWord.contains(".")) {
                String[] split = sqlWord.split("\\.");
                schemas.add(split[0].replaceAll("'", ""));
                continue;
            }
            schemas.add(sqlWord.replaceAll("'", ""));
        }
        return schemas;
    }

    public static List<String> tablesInSql(String sql) {
        List<String> insertTable = SqlUtils.insertTable(sql);
        List<String> updateTable = SqlUtils.updateTable(sql);
        List<String> selectTable = SqlUtils.selectTable(sql);
        String errorTable = SqlUtils.errorMessageWithTable(sql);
        ArrayList<String> tableNames = new ArrayList<String>();
        if (errorTable != null) {
            tableNames.add(errorTable);
        }
        tableNames.addAll(insertTable);
        tableNames.addAll(updateTable);
        tableNames.addAll(selectTable);
        return tableNames;
    }

    public static List<String> tablesInSql(List<String> sqlList) {
        ArrayList<String> tableNames = new ArrayList<String>();
        for (String sql : sqlList) {
            List<String> tablesInSql = SqlUtils.tablesInSql(sql);
            tableNames.addAll(tablesInSql);
        }
        return tableNames;
    }

    public static String whereConditionsInSql(String sql) {
        String sqlUpperCase = sql.toUpperCase();
        if (sqlUpperCase.contains("WHERE")) {
            return sql.substring(sqlUpperCase.lastIndexOf("WHERE"));
        }
        return "";
    }

    public static Map<String, Object> setDataInSql(String sql) {
        String sqlUpperCase = sql.toUpperCase();
        HashMap<String, Object> data = new HashMap<String, Object>();
        String substring = sql.substring(sqlUpperCase.indexOf("SET") + 3, sqlUpperCase.contains("WHERE") ? sqlUpperCase.lastIndexOf("WHERE") : sqlUpperCase.length());
        for (String split : substring.split(",")) {
            if (!split.contains("=")) continue;
            String[] kv = split.split("=");
            String k = kv[0];
            String v = kv[1];
            data.put(k.replaceAll(" ", ""), v.replaceAll(" ", ""));
        }
        return data;
    }

    public static List<Map<String, Object>> insertDataInSql(String sql) {
        ArrayList<Map<String, Object>> insertData = new ArrayList<Map<String, Object>>();
        String upperCase = sql.toUpperCase();
        if (upperCase.contains("INSERT")) {
            String keyString = sql.substring(upperCase.indexOf("(") + 1, upperCase.indexOf(")"));
            String[] keyList = keyString.split(",");
            String valuesString = sql.substring(upperCase.indexOf("VALUES") + "VALUES".length(), upperCase.contains("ON DUPLICATE KEY UPDATE") ? upperCase.indexOf("ON DUPLICATE KEY UPDATE") : upperCase.length());
            valuesString = valuesString.replaceFirst("\\(", "");
            String[] valueItemList = null;
            if (valuesString.contains("),")) {
                String regex = "\\),";
                valuesString = valuesString.replaceAll("\\(", "");
                valueItemList = valuesString.substring(0, valuesString.lastIndexOf(")")).split(regex);
            } else {
                valueItemList = new String[]{valuesString.substring(0, valuesString.lastIndexOf(")"))};
            }
            for (String valueItem : valueItemList) {
                HashMap<String, String> dataItem = new HashMap<String, String>();
                String[] valueList = valueItem.split(",");
                for (int i = 0; i < keyList.length; ++i) {
                    String value = valueList[i];
                    String cleanedValue = value.replaceAll(" ", "");
                    if (cleanedValue.startsWith("'") && cleanedValue.endsWith("'")) {
                        cleanedValue = cleanedValue.substring(1, cleanedValue.length() - 1);
                    }
                    String key = keyList[i];
                    dataItem.put(key.replaceAll(" ", ""), cleanedValue);
                }
                insertData.add(dataItem);
            }
        }
        return insertData;
    }

    public static List<Map<String, Object>> dataInSql(String sql) {
        String upperCase = sql.toUpperCase();
        if (upperCase.contains("INSERT")) {
            return SqlUtils.insertDataInSql(sql);
        }
        Map<String, Object> data = SqlUtils.setDataInSql(sql);
        return Arrays.asList(data);
    }

    public static SqlPart createSqlPartFromSql(String sql) {
        SqlPart sqlPart = new SqlPart();
        Persistence.ExecutionEnum executionEnum = SqlColumnUtils.executionEnumInSql(sql);
        sqlPart.setExecutionEnum(executionEnum);
        List<String> tables = SqlUtils.tablesInSql(sql);
        String tableName = tables.get(0);
        sqlPart.setPrimaryTable(tableName);
        ConcurrentMap classTableCache = SourceFactory.getClassTableCache();
        if (classTableCache.values().stream().anyMatch(lazyTableEndpoint -> lazyTableEndpoint.getTableName().equals(tableName))) {
            LazyTableEndpoint lazyTableEndpoint2 = classTableCache.values().stream().filter(l -> l.getTableName().equals(tableName)).findFirst().get();
            sqlPart.setPrimaryClass(lazyTableEndpoint2.getClazz());
        }
        switch (executionEnum) {
            case INSERT: {
                List<Map<String, Object>> insertDataInSql1 = SqlUtils.insertDataInSql(sql);
                List hashMaps1 = insertDataInSql1.stream().map(HashMap::new).collect(Collectors.toList());
                sqlPart.setInsert(hashMaps1);
            }
            case UPSERT: {
                List<Map<String, Object>> insertDataInSql = SqlUtils.insertDataInSql(sql);
                List hashMaps = insertDataInSql.stream().map(HashMap::new).collect(Collectors.toList());
                sqlPart.setInsert(hashMaps);
            }
            case SELECT: {
                String string = SqlUtils.whereConditionsInSql(sql);
            }
            case UPDATE: {
                List<Condition> updateSetColumn = SqlColumnUtils.updateSetColumn(sql);
                List<Condition> updateWhereConditions = SqlColumnUtils.updateConditionColumn(sql);
                sqlPart.setUpdateSet(updateSetColumn.stream().collect(Collectors.toMap(c -> c.getRowName().toString(), Condition::getRowValue)));
                sqlPart.setConditionType(" WHERE ");
                for (Condition updateWhereCondition : updateWhereConditions) {
                    sqlPart.put(updateWhereCondition.getRowName(), updateWhereCondition.getType(), updateWhereCondition.getRowValue());
                }
                break;
            }
        }
        return sqlPart;
    }
}

