/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.sql.util;

import java.util.ArrayList;
import java.util.List;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.core.utils.StringUtils;
import org.wu.framework.lazy.orm.core.config.enums.RowValueType;
import org.wu.framework.lazy.orm.database.lambda.domain.Persistence;
import org.wu.framework.lazy.orm.database.lambda.stream.LambdaTableType;
import org.wu.framework.lazy.orm.database.lambda.stream.condition.part.Condition;

public class SqlColumnUtils {
    public static List<String> insertColumn(String insertSql) {
        String[] sqlWords;
        ArrayList<String> columnNames = new ArrayList<String>();
        int hitNum = 0;
        for (String sqlWord : sqlWords = insertSql.replaceAll("`", "").replaceAll("\n", " ").split(" ")) {
            if (ObjectUtils.isEmpty((Object)sqlWord)) continue;
            if (sqlWord.equalsIgnoreCase("INSERT")) {
                ++hitNum;
                continue;
            }
            if (sqlWord.equalsIgnoreCase("INTO")) {
                ++hitNum;
                continue;
            }
            if (sqlWord.equalsIgnoreCase("(")) {
                ++hitNum;
                continue;
            }
            if (sqlWord.startsWith("values") || sqlWord.startsWith("VALUES")) {
                return columnNames;
            }
            if (hitNum != 3) continue;
            columnNames.add(sqlWord);
        }
        return columnNames;
    }

    public static List<Condition> selectConditionColumn(String selectSql) {
        ArrayList<Condition> conditionList = new ArrayList<Condition>();
        int hitNum = 0;
        String[] sqlWords = selectSql.replaceAll("`", "").replaceAll("\n", " ").split(" ");
        Condition condition = null;
        for (String sqlWord : sqlWords) {
            if (ObjectUtils.isEmpty((Object)sqlWord)) continue;
            if (sqlWord.equalsIgnoreCase("select")) {
                hitNum = 1;
                continue;
            }
            if (sqlWord.equalsIgnoreCase("from")) {
                hitNum = 2;
                continue;
            }
            if (hitNum == 2 && sqlWord.equalsIgnoreCase("(")) {
                hitNum = 0;
                continue;
            }
            if (hitNum == 2 && sqlWord.equalsIgnoreCase("(select")) {
                hitNum = 1;
                continue;
            }
            if (hitNum == 2 && (sqlWord.equalsIgnoreCase("where") || sqlWord.equalsIgnoreCase("on"))) {
                hitNum = 3;
                continue;
            }
            if (hitNum == 3 && (sqlWord.equalsIgnoreCase("left") || sqlWord.equalsIgnoreCase("right") || sqlWord.equalsIgnoreCase("join"))) {
                hitNum = 2;
                continue;
            }
            if (hitNum != 3 || !(condition = SqlColumnUtils.getConditionColumnName(sqlWord, condition)).satisfyGrammar()) continue;
            conditionList.add(condition);
            condition = null;
        }
        return conditionList;
    }

    public static List<String> selectColumn(String selectSql) {
        String[] sqlWords;
        ArrayList<String> columnNames = new ArrayList<String>();
        int hitNum = 0;
        for (String sqlWord : sqlWords = selectSql.replaceAll("`", "").replaceAll("\n", " ").split(" ")) {
            if (ObjectUtils.isEmpty((Object)sqlWord)) continue;
            if (sqlWord.equalsIgnoreCase("select")) {
                hitNum = 1;
                continue;
            }
            if (sqlWord.equalsIgnoreCase("from")) {
                hitNum = 2;
                continue;
            }
            if (hitNum == 2 && sqlWord.equalsIgnoreCase("(")) {
                hitNum = 0;
                continue;
            }
            if (hitNum == 2 && sqlWord.equalsIgnoreCase("(select")) {
                hitNum = 1;
                continue;
            }
            if (hitNum != 1) continue;
            columnNames.add(sqlWord);
        }
        return columnNames;
    }

    public static Condition getConditionColumnName(String sqlWord, Condition condition) {
        if (ObjectUtils.isEmpty((Object)condition)) {
            condition = new Condition();
        }
        if (Condition.SQL_SPLICING_SYMBOLS_LIST.contains(sqlWord)) {
            return condition;
        }
        if (Condition.TYPE_LIST.contains(sqlWord)) {
            condition.setType(sqlWord);
            return condition;
        }
        if (condition.getRowName() == null) {
            condition.setRowName((Object)sqlWord);
            return condition;
        }
        if (condition.getRowValue() == null) {
            RowValueType rowValueType = RowValueType.STRING;
            if (sqlWord.startsWith("$")) {
                rowValueType = RowValueType.EXPRESSION;
                sqlWord = sqlWord.replaceFirst("${", "").replace("}", "");
            }
            condition.setRowValue((Object)sqlWord);
            condition.setRowValueType(rowValueType);
            return condition;
        }
        return condition;
    }

    public static List<Condition> updateConditionColumn(String updateSql) {
        ArrayList<Condition> columnNames = new ArrayList<Condition>();
        int hitNum = 0;
        boolean hitIgnoreNum = false;
        String[] sqlWords = updateSql.replaceAll("`", "").replaceAll("\n", " ").split(" ");
        Condition conditionColumnName = null;
        for (String sqlWord : sqlWords) {
            if (ObjectUtils.isEmpty((Object)sqlWord)) continue;
            if (sqlWord.equalsIgnoreCase("UPDATE")) {
                hitNum = 1;
                continue;
            }
            if (hitNum == 1) {
                hitNum = 2;
                continue;
            }
            if (hitNum == 2 && sqlWord.equalsIgnoreCase("set")) {
                hitNum = 3;
                continue;
            }
            if (hitNum == 3 && sqlWord.equalsIgnoreCase("where")) {
                hitNum = 4;
                continue;
            }
            if (hitNum != 4 || !(conditionColumnName = SqlColumnUtils.getConditionColumnName(sqlWord, conditionColumnName)).satisfyGrammar()) continue;
            columnNames.add(conditionColumnName);
            conditionColumnName = null;
        }
        return columnNames;
    }

    public static List<Condition> updateSetColumn(String updateSql) {
        ArrayList<Condition> columnNames = new ArrayList<Condition>();
        int hitNum = 0;
        boolean hitIgnoreNum = false;
        String[] sqlWords = updateSql.replaceAll("`", "").replaceAll("\n", " ").split(" ");
        Condition conditionColumnName = null;
        for (String sqlWord : sqlWords) {
            if (ObjectUtils.isEmpty((Object)sqlWord)) continue;
            if (sqlWord.equalsIgnoreCase("UPDATE")) {
                hitNum = 1;
                continue;
            }
            if (hitNum == 1) {
                hitNum = 2;
                continue;
            }
            if (hitNum == 2 && sqlWord.equalsIgnoreCase("set")) {
                hitNum = 3;
                continue;
            }
            if (hitNum == 3 && sqlWord.equalsIgnoreCase("where")) {
                hitNum = 4;
                return columnNames;
            }
            if (hitNum != 3 || !(conditionColumnName = SqlColumnUtils.getConditionColumnName(sqlWord, conditionColumnName)).satisfyGrammar()) continue;
            columnNames.add(conditionColumnName);
            conditionColumnName = null;
        }
        return columnNames;
    }

    public static List<String> updateColumn(String updateSql) {
        String[] sqlWords;
        ArrayList<String> columnNames = new ArrayList<String>();
        int hitNum = 0;
        boolean hitIgnoreNum = false;
        for (String sqlWord : sqlWords = updateSql.replaceAll("`", "").replaceAll("\n", " ").split(" ")) {
            if (ObjectUtils.isEmpty((Object)sqlWord)) continue;
            if (sqlWord.equalsIgnoreCase("UPDATE")) {
                hitNum = 1;
                continue;
            }
            if (hitNum == 1) {
                hitNum = 2;
                continue;
            }
            if (hitNum == 2 && sqlWord.equalsIgnoreCase("set")) {
                hitNum = 3;
                continue;
            }
            if (hitNum == 3 && sqlWord.equalsIgnoreCase("where")) {
                hitNum = 4;
                continue;
            }
            if (hitNum != 3) continue;
            columnNames.add(sqlWord);
        }
        return columnNames;
    }

    public static List<Condition> columnConditionInSql(String sql) {
        List<Condition> updateConditionColumn = SqlColumnUtils.updateConditionColumn(sql);
        List<Condition> selectConditionColumn = SqlColumnUtils.selectConditionColumn(sql);
        ArrayList<Condition> tableColumns = new ArrayList<Condition>();
        tableColumns.addAll(updateConditionColumn);
        tableColumns.addAll(selectConditionColumn);
        return tableColumns;
    }

    public static LambdaTableType executeTypeInSql(String sql) {
        if (StringUtils.startsWithIgnoreCase((String)(sql = sql.trim()), (String)LambdaTableType.DELETE.getValue())) {
            return LambdaTableType.DELETE;
        }
        if (StringUtils.startsWithIgnoreCase((String)sql, (String)LambdaTableType.INSERT.getValue())) {
            return LambdaTableType.INSERT;
        }
        if (StringUtils.startsWithIgnoreCase((String)sql, (String)LambdaTableType.UPDATE.getValue())) {
            return LambdaTableType.UPDATE;
        }
        if (StringUtils.startsWithIgnoreCase((String)sql, (String)LambdaTableType.CREATE.getValue())) {
            return LambdaTableType.CREATE;
        }
        if (StringUtils.startsWithIgnoreCase((String)sql, (String)LambdaTableType.SELECT.getValue()) || StringUtils.startsWithIgnoreCase((String)sql, (String)"show") || StringUtils.startsWithIgnoreCase((String)sql, (String)"describe")) {
            return LambdaTableType.SELECT;
        }
        if (StringUtils.startsWithIgnoreCase((String)sql, (String)"alert")) {
            return LambdaTableType.DDL;
        }
        return LambdaTableType.NONE;
    }

    public static Persistence.ExecutionEnum executionEnumInSql(String sql) {
        if (StringUtils.startsWithIgnoreCase((String)(sql = sql.trim()), (String)LambdaTableType.DELETE.getValue())) {
            return Persistence.ExecutionEnum.DELETE;
        }
        if (StringUtils.startsWithIgnoreCase((String)sql, (String)LambdaTableType.INSERT.getValue())) {
            return Persistence.ExecutionEnum.INSERT;
        }
        if (StringUtils.startsWithIgnoreCase((String)sql, (String)LambdaTableType.UPDATE.getValue())) {
            return Persistence.ExecutionEnum.UPDATE;
        }
        if (StringUtils.startsWithIgnoreCase((String)sql, (String)LambdaTableType.CREATE.getValue())) {
            return Persistence.ExecutionEnum.UPDATE;
        }
        if (StringUtils.startsWithIgnoreCase((String)sql, (String)LambdaTableType.SELECT.getValue()) || StringUtils.startsWithIgnoreCase((String)sql, (String)"show") || StringUtils.startsWithIgnoreCase((String)sql, (String)"describe")) {
            return Persistence.ExecutionEnum.SELECT;
        }
        if (StringUtils.startsWithIgnoreCase((String)sql, (String)"alert")) {
            return Persistence.ExecutionEnum.UPDATE;
        }
        return Persistence.ExecutionEnum.NONE;
    }

    public static List<String> columnInSql(String sql) {
        List<String> insertColumn = SqlColumnUtils.insertColumn(sql);
        List<String> updateColumn = SqlColumnUtils.updateColumn(sql);
        List<String> selectColumn = SqlColumnUtils.selectColumn(sql);
        ArrayList<String> tableColumns = new ArrayList<String>();
        tableColumns.addAll(insertColumn);
        tableColumns.addAll(updateColumn);
        tableColumns.addAll(selectColumn);
        return tableColumns;
    }

    public static List<String> columnInSql(List<String> sqlList) {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (String sql : sqlList) {
            List<String> columnInSql = SqlColumnUtils.columnInSql(sql);
            columnNames.addAll(columnInSql);
        }
        return columnNames;
    }
}

