/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.sql.smart.database.persistence;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wu.framework.core.stereotype.MethodParamFunctionException;
import org.wu.framework.core.utils.FileUtil;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.factory.LazyTableUpsertConverterFactory;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyDatabase;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableInfo;
import org.wu.framework.lazy.orm.core.persistence.map.EasyHashMap;
import org.wu.framework.lazy.orm.core.source.mysql.MySQLLazyTableInfo;
import org.wu.framework.lazy.orm.database.lambda.stream.condition.BasicComparison;
import org.wu.framework.lazy.orm.database.lambda.stream.lambda.LazyLambdaStream;
import org.wu.framework.lazy.orm.database.lambda.stream.wrapper.LazyWrappers;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.config.ExportDataAttribute;
import org.wu.framework.lazy.orm.database.sql.smart.database.Perfect;
import org.wu.framework.translation.data.ProcessException;
import org.wu.framework.translation.data.schema.SchemaMap;

public class PerfectLazyOperation
implements Perfect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PerfectLazyOperation.class);
    private final String tableTemp = "\n-- ----------------------------\n-- LazyTableInfo data for %s   \u7b2c\u3010 %s ~ %s \u3011\u6761\u6570\u636e  \n-- LazyTableInfo table_comment for %s \n-- ----------------------------";
    private final ExportDataAttribute exportDataAttribute;
    private final LazyLambdaStream lazyLambdaStream;

    public PerfectLazyOperation(ExportDataAttribute exportDataAttribute, LazyLambdaStream lazyLambdaStream) {
        this.exportDataAttribute = exportDataAttribute;
        this.lazyLambdaStream = lazyLambdaStream;
    }

    @Override
    public File saveSqlFile(String nameDatabase) throws IOException {
        if (nameDatabase == null) {
            nameDatabase = (String)this.lazyLambdaStream.executeSQLForBean("select database()", String.class, new Object[0]);
        }
        List lazyTableInfoList = this.lazyLambdaStream.selectList((BasicComparison)LazyWrappers.lambdaWrapper().eq(LazyTableInfo::getTableSchema, (Object)nameDatabase).functionAs(String.format("concat('%s.',table_name)", nameDatabase), LazyTableInfo::getTableName));
        File file = FileUtil.createFile((String)System.getProperty("user.dir"), (String)String.format("\u6570\u636e\u5e93%s\u6570\u636e.sql", nameDatabase));
        BufferedWriter fileBufferedWriter = FileUtil.createFileBufferedWriter((File)file);
        fileBufferedWriter.newLine();
        fileBufferedWriter.write(String.format("use %s;", nameDatabase));
        fileBufferedWriter.newLine();
        for (LazyTableInfo table : lazyTableInfoList) {
            EasyHashMap one;
            List ignoreFields;
            String countSQL = "select count(1) from {0} ";
            String tableName = table.getTableName();
            SchemaMap createTableSchema = (SchemaMap)this.lazyLambdaStream.executeSQLForBean("show create table {0}", SchemaMap.class, new Object[]{tableName});
            Object createTableSql = createTableSchema.get((Object)"Create Table");
            fileBufferedWriter.write("DROP TABLE IF EXISTS " + tableName.replace(nameDatabase + ".", "") + ";");
            fileBufferedWriter.newLine();
            fileBufferedWriter.write(String.valueOf(createTableSql));
            fileBufferedWriter.write(";");
            if (ObjectUtils.isEmpty((Object)tableName)) {
                System.out.println(tableName);
            }
            String tableComment = table.getTableComment();
            Long count = (Long)this.lazyLambdaStream.executeSQLForBean(countSQL, Long.class, new Object[]{tableName});
            if (count == 0L) continue;
            AtomicReference tableInfo = new AtomicReference();
            String selectSQL = "select * from {0} ";
            if (count > 1000L) {
                this.lazyLambdaStream.scroll(null, EasyHashMap.class, selectSQL, scrollPage -> {
                    try {
                        if (ObjectUtils.isEmpty((Object)scrollPage.getRecords())) {
                            return;
                        }
                        List record = (List)scrollPage.getRecords();
                        List<String> ignoreExportedFields = this.exportDataAttribute.getIgnoreExportedFields();
                        if (!ObjectUtils.isEmpty(ignoreExportedFields)) {
                            EasyHashMap one = (EasyHashMap)record.get(0);
                            List ignoreFields = one.keySet().stream().filter(ignoreExportedFields::contains).collect(Collectors.toList());
                            if (!ObjectUtils.isEmpty(ignoreFields)) {
                                List ignoredData;
                                record = ignoredData = record.stream().map(easyHashMap -> {
                                    for (Object ignoreField : ignoreFields) {
                                        easyHashMap.remove(ignoreField);
                                    }
                                    return easyHashMap;
                                }).collect(Collectors.toList());
                            }
                        }
                        tableInfo.set(record.get(0));
                        int from = (scrollPage.getCurrent() - 1) * scrollPage.getSize();
                        int to = from + scrollPage.getRecords().size();
                        fileBufferedWriter.write(String.format("\n-- ----------------------------\n-- LazyTableInfo data for %s   \u7b2c\u3010 %s ~ %s \u3011\u6761\u6570\u636e  \n-- LazyTableInfo table_comment for %s \n-- ----------------------------", tableName, from, to, tableComment));
                        fileBufferedWriter.newLine();
                        ((EasyHashMap)tableInfo.get()).setUniqueLabel(tableName);
                        String s = LazyTableUpsertConverterFactory.upsert(record);
                        s = s.replaceAll("'true'", "1").replaceAll("'false'", "0").replaceAll("'null'", "null");
                        fileBufferedWriter.write(s);
                        fileBufferedWriter.write(";");
                        fileBufferedWriter.newLine();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }, new Object[]{tableName});
                continue;
            }
            List tableDateList = this.lazyLambdaStream.executeSQL(selectSQL, EasyHashMap.class, new Object[]{tableName});
            if (ObjectUtils.isEmpty((Object)tableDateList)) continue;
            List<String> ignoreExportedFields = this.exportDataAttribute.getIgnoreExportedFields();
            if (!ObjectUtils.isEmpty(ignoreExportedFields) && !ObjectUtils.isEmpty(ignoreFields = (one = (EasyHashMap)tableDateList.get(0)).keySet().stream().filter(key -> ignoreExportedFields.contains(key)).collect(Collectors.toList()))) {
                List ignoredData;
                tableDateList = ignoredData = tableDateList.stream().map(easyHashMap -> {
                    for (Object ignoreField : ignoreFields) {
                        easyHashMap.remove(ignoreField);
                    }
                    return easyHashMap;
                }).collect(Collectors.toList());
            }
            int from = 0;
            int to = tableDateList.size();
            fileBufferedWriter.write(String.format("\n-- ----------------------------\n-- LazyTableInfo data for %s   \u7b2c\u3010 %s ~ %s \u3011\u6761\u6570\u636e  \n-- LazyTableInfo table_comment for %s \n-- ----------------------------", tableName, from, to, tableComment));
            fileBufferedWriter.newLine();
            tableInfo.set(tableDateList.get(0));
            ((EasyHashMap)tableInfo.get()).setUniqueLabel(tableName);
            String s = LazyTableUpsertConverterFactory.upsert(tableDateList);
            s = s.replaceAll("'true'", "1").replaceAll("'false'", "0").replaceAll("'null'", "null");
            fileBufferedWriter.write(s);
            fileBufferedWriter.write(";");
            fileBufferedWriter.newLine();
        }
        fileBufferedWriter.close();
        log.info("\u6570\u636e\u5907\u4efd\u7ed3\u675f\u8f93\u51fa\u6587\u4ef6\u5730\u5740:" + System.getProperty("user.dir"));
        return file;
    }

    public void saveSqlFile() throws ProcessException, SQLException, MethodParamFunctionException, IOException, ExecutionException, InterruptedException {
        List<LazyDatabase> databaseList = this.showDatabases();
        for (LazyDatabase database : databaseList) {
            this.saveSqlFile(database.getDatabase());
        }
    }

    public void saveSoftSqlFile() throws ProcessException, SQLException, MethodParamFunctionException, IOException, ExecutionException, InterruptedException {
        List<LazyDatabase> databaseList = this.showDatabases();
        for (LazyDatabase database : databaseList) {
            this.saveSoftSqlFile(database.getDatabase());
        }
    }

    @Override
    public File saveSoftSqlFile(String nameDatabase) throws ProcessException, SQLException, MethodParamFunctionException, IOException, ExecutionException, InterruptedException {
        if (nameDatabase == null) {
            nameDatabase = (String)this.lazyLambdaStream.executeSQLForBean("select database()", String.class, new Object[0]);
        }
        String sqlSelectTable = "select concat('%s.',table_name) tableName, engine, table_comment tableComment, create_time createTime from information_schema.tables where table_schema = '%s' ";
        List allTables = this.lazyLambdaStream.executeSQL(String.format(sqlSelectTable, nameDatabase, nameDatabase), EasyHashMap.class, new Object[0]);
        File file = FileUtil.createFile((String)System.getProperty("user.dir"), (String)String.format("\u6570\u636e\u5e93%s\u6570\u636e.sql", nameDatabase));
        BufferedWriter fileBufferedWriter = FileUtil.createFileBufferedWriter((File)file);
        fileBufferedWriter.newLine();
        fileBufferedWriter.write(String.format("use %s;", nameDatabase));
        fileBufferedWriter.newLine();
        for (EasyHashMap table : allTables) {
            EasyHashMap one;
            List ignoreFields;
            String countSQL = "select count(1) from %s ";
            String tableName = table.get((Object)"tableName").toString();
            SchemaMap createTableSchema = (SchemaMap)this.lazyLambdaStream.executeSQLForBean("show create table %s", SchemaMap.class, new Object[]{tableName});
            String createTableSql = String.valueOf(createTableSchema.get((Object)"Create Table"));
            fileBufferedWriter.newLine();
            createTableSql = createTableSql.replaceAll("CREATE TABLE", "CREATE TABLE IF NOT EXISTS");
            fileBufferedWriter.write(createTableSql);
            fileBufferedWriter.write(";");
            Object tableComment = table.get((Object)"TABLECOMMENT");
            Long count = (Long)this.lazyLambdaStream.executeSQLForBean(String.format(countSQL, tableName), Long.class, new Object[0]);
            if (count == 0L) continue;
            AtomicReference tableInfo = new AtomicReference();
            String selectSQL = "select * from %s ";
            if (count > 1000L) {
                this.lazyLambdaStream.scroll(null, EasyHashMap.class, selectSQL, scrollPage -> {
                    try {
                        EasyHashMap one;
                        List ignoreFields;
                        if (ObjectUtils.isEmpty((Object)scrollPage.getRecords())) {
                            return;
                        }
                        List record = (List)scrollPage.getRecords();
                        List<String> ignoreExportedFields = this.exportDataAttribute.getIgnoreExportedFields();
                        if (!ObjectUtils.isEmpty(ignoreExportedFields) && !ObjectUtils.isEmpty(ignoreFields = (one = (EasyHashMap)record.get(0)).keySet().stream().filter(key -> ignoreExportedFields.contains(key)).collect(Collectors.toList()))) {
                            List ignoredData;
                            record = ignoredData = record.stream().map(easyHashMap -> {
                                for (Object ignoreField : ignoreFields) {
                                    easyHashMap.remove(ignoreField);
                                }
                                return easyHashMap;
                            }).collect(Collectors.toList());
                        }
                        tableInfo.set(record.get(0));
                        int from = (scrollPage.getCurrent() - 1) * scrollPage.getSize();
                        int to = from + scrollPage.getRecords().size();
                        fileBufferedWriter.write(String.format("\n-- ----------------------------\n-- LazyTableInfo data for %s   \u7b2c\u3010 %s ~ %s \u3011\u6761\u6570\u636e  \n-- LazyTableInfo table_comment for %s \n-- ----------------------------", tableName, from, to, tableComment));
                        fileBufferedWriter.newLine();
                        ((EasyHashMap)tableInfo.get()).setUniqueLabel(tableName);
                        String s = LazyTableUpsertConverterFactory.upsert(record);
                        s = s.replaceAll("'true'", "1").replaceAll("'false'", "0").replaceAll("'null'", "null");
                        fileBufferedWriter.write(s);
                        fileBufferedWriter.write(";");
                        fileBufferedWriter.newLine();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }, new Object[]{tableName});
                continue;
            }
            List tableDateList = this.lazyLambdaStream.executeSQL(String.format(selectSQL, tableName), EasyHashMap.class, new Object[0]);
            if (ObjectUtils.isEmpty((Object)tableDateList)) continue;
            List<String> ignoreExportedFields = this.exportDataAttribute.getIgnoreExportedFields();
            if (!ObjectUtils.isEmpty(ignoreExportedFields) && !ObjectUtils.isEmpty(ignoreFields = (one = (EasyHashMap)tableDateList.get(0)).keySet().stream().filter(key -> ignoreExportedFields.contains(key)).collect(Collectors.toList()))) {
                List ignoredData;
                tableDateList = ignoredData = tableDateList.stream().map(easyHashMap -> {
                    for (Object ignoreField : ignoreFields) {
                        easyHashMap.remove(ignoreField);
                    }
                    return easyHashMap;
                }).collect(Collectors.toList());
            }
            int from = 0;
            int to = tableDateList.size();
            fileBufferedWriter.write(String.format("\n-- ----------------------------\n-- LazyTableInfo data for %s   \u7b2c\u3010 %s ~ %s \u3011\u6761\u6570\u636e  \n-- LazyTableInfo table_comment for %s \n-- ----------------------------", tableName, from, to, tableComment));
            fileBufferedWriter.newLine();
            tableInfo.set(tableDateList.get(0));
            ((EasyHashMap)tableInfo.get()).setUniqueLabel(tableName);
            String s = LazyTableUpsertConverterFactory.upsert(tableDateList);
            s = s.replaceAll("'true'", "1").replaceAll("'false'", "0").replaceAll("'null'", "null");
            fileBufferedWriter.write(s);
            fileBufferedWriter.write(";");
            fileBufferedWriter.newLine();
        }
        fileBufferedWriter.close();
        log.info("\u6570\u636e\u5907\u4efd\u7ed3\u675f\u8f93\u51fa\u6587\u4ef6\u5730\u5740:" + System.getProperty("user.dir"));
        return file;
    }

    @Override
    public String saveSoftTableStructureSql(String nameDatabase) {
        if (nameDatabase == null) {
            nameDatabase = (String)this.lazyLambdaStream.executeSQLForBean("select database()", String.class, new Object[0]);
        }
        String sqlSelectTable = "select concat('%s.',table_name) tableName, engine, table_comment tableComment, create_time createTime from information_schema.tables where table_schema = '%s' ";
        List allTables = this.lazyLambdaStream.executeSQL(String.format(sqlSelectTable, nameDatabase, nameDatabase), EasyHashMap.class, new Object[0]);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n");
        stringBuilder.append(String.format("use %s;", nameDatabase));
        for (EasyHashMap table : allTables) {
            String tableName = table.get((Object)"tableName").toString();
            SchemaMap createTableSchema = (SchemaMap)this.lazyLambdaStream.executeSQLForBean("show create table %s", SchemaMap.class, new Object[]{tableName});
            String createTableSql = String.valueOf(createTableSchema.get((Object)"Create Table"));
            stringBuilder.append("\n");
            createTableSql = createTableSql.replaceAll("CREATE TABLE", "CREATE TABLE IF NOT EXISTS");
            stringBuilder.append(createTableSql);
            stringBuilder.append(";");
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public File saveUpsertSqlFile(String nameDatabase) throws ProcessException, SQLException, MethodParamFunctionException, IOException, ExecutionException, InterruptedException {
        String filePackage = System.getProperty("user.dir") + File.separator + "data_file" + File.separator + nameDatabase;
        if (nameDatabase == null) {
            nameDatabase = (String)this.lazyLambdaStream.executeSQLForBean("select database()", String.class, new Object[0]);
        }
        String sqlSelectTable = "select concat('%s.',table_name) tableName, engine, table_comment tableComment, create_time createTime from information_schema.tables where table_schema = '%s' ";
        List allTables = this.lazyLambdaStream.executeSQL(String.format(sqlSelectTable, nameDatabase, nameDatabase), EasyHashMap.class, new Object[0]);
        File file = FileUtil.createFile((String)System.getProperty("user.dir"), (String)String.format("\u6570\u636e\u5e93%s\u6570\u636e.sql", nameDatabase));
        BufferedWriter fileBufferedWriter = FileUtil.createFileBufferedWriter((File)file);
        fileBufferedWriter.newLine();
        fileBufferedWriter.write(String.format("use %s;", nameDatabase));
        fileBufferedWriter.newLine();
        for (EasyHashMap table : allTables) {
            EasyHashMap one;
            List ignoreFields;
            String countSQL = "select count(1) from %s ";
            String tableName = table.get((Object)"tableName").toString();
            if (ObjectUtils.isEmpty((Object)tableName)) continue;
            Object tableComment = table.get((Object)"TABLECOMMENT");
            Long count = (Long)this.lazyLambdaStream.executeSQLForBean(String.format(countSQL, tableName), Long.class, new Object[0]);
            if (count == 0L) continue;
            AtomicReference tableInfo = new AtomicReference();
            String selectSQL = "select * from %s ";
            if (count > 1000L) {
                this.lazyLambdaStream.scroll(null, EasyHashMap.class, String.format(selectSQL, tableName), scrollPage -> {
                    try {
                        if (ObjectUtils.isEmpty((Object)scrollPage.getRecords())) {
                            return;
                        }
                        List record = (List)scrollPage.getRecords();
                        List<String> ignoreExportedFields = this.exportDataAttribute.getIgnoreExportedFields();
                        if (!ObjectUtils.isEmpty(ignoreExportedFields)) {
                            EasyHashMap one = (EasyHashMap)record.get(0);
                            List ignoreFields = one.keySet().stream().filter(ignoreExportedFields::contains).collect(Collectors.toList());
                            if (!ObjectUtils.isEmpty(ignoreFields)) {
                                List ignoredData;
                                record = ignoredData = record.stream().map(easyHashMap -> {
                                    for (Object ignoreField : ignoreFields) {
                                        easyHashMap.remove(ignoreField);
                                    }
                                    return easyHashMap;
                                }).collect(Collectors.toList());
                            }
                        }
                        tableInfo.set(record.get(0));
                        int from = (scrollPage.getCurrent() - 1) * scrollPage.getSize();
                        int to = from + scrollPage.getRecords().size();
                        fileBufferedWriter.write(String.format("\n-- ----------------------------\n-- LazyTableInfo data for %s   \u7b2c\u3010 %s ~ %s \u3011\u6761\u6570\u636e  \n-- LazyTableInfo table_comment for %s \n-- ----------------------------", tableName, from, to, tableComment));
                        fileBufferedWriter.newLine();
                        ((EasyHashMap)tableInfo.get()).setUniqueLabel(tableName);
                        String s = LazyTableUpsertConverterFactory.upsert(record);
                        s = s.replaceAll("'true'", "1").replaceAll("'false'", "0").replaceAll("'null'", "null");
                        fileBufferedWriter.write(s);
                        fileBufferedWriter.write(";");
                        fileBufferedWriter.newLine();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }, new Object[0]);
                continue;
            }
            List tableDateList = this.lazyLambdaStream.executeSQL(String.format(selectSQL, tableName), EasyHashMap.class, new Object[0]);
            if (ObjectUtils.isEmpty((Object)tableDateList)) continue;
            List<String> ignoreExportedFields = this.exportDataAttribute.getIgnoreExportedFields();
            if (!ObjectUtils.isEmpty(ignoreExportedFields) && !ObjectUtils.isEmpty(ignoreFields = (one = (EasyHashMap)tableDateList.get(0)).keySet().stream().filter(key -> ignoreExportedFields.contains(key)).collect(Collectors.toList()))) {
                List ignoredData;
                tableDateList = ignoredData = tableDateList.stream().map(easyHashMap -> {
                    for (Object ignoreField : ignoreFields) {
                        easyHashMap.remove(ignoreField);
                    }
                    return easyHashMap;
                }).collect(Collectors.toList());
            }
            int from = 0;
            int to = tableDateList.size();
            fileBufferedWriter.write(String.format("\n-- ----------------------------\n-- LazyTableInfo data for %s   \u7b2c\u3010 %s ~ %s \u3011\u6761\u6570\u636e  \n-- LazyTableInfo table_comment for %s \n-- ----------------------------", tableName, from, to, tableComment));
            fileBufferedWriter.newLine();
            tableInfo.set(tableDateList.get(0));
            ((EasyHashMap)tableInfo.get()).setUniqueLabel(tableName);
            String s = LazyTableUpsertConverterFactory.upsert(tableDateList);
            s = s.replaceAll("'true'", "1").replaceAll("'false'", "0").replaceAll("'null'", "null");
            fileBufferedWriter.write(s);
            fileBufferedWriter.write(";");
            fileBufferedWriter.newLine();
        }
        fileBufferedWriter.close();
        log.info("\u6570\u636e\u5907\u4efd\u7ed3\u675f\u8f93\u51fa\u6587\u4ef6\u5730\u5740:" + System.getProperty("user.dir"));
        return file;
    }

    @Override
    public List<LazyDatabase> showDatabases() {
        List databaseList = this.lazyLambdaStream.executeSQL("show databases;", LazyDatabase.class, new Object[0]);
        return databaseList;
    }

    @Override
    public List<MySQLLazyTableInfo> showTables(String schemaName) {
        List tables = this.lazyLambdaStream.selectList((BasicComparison)LazyWrappers.lambdaWrapper().eq(MySQLLazyTableInfo::getTableSchema, (Object)schemaName));
        return tables;
    }
}

