/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.sql.smart.database.persistence;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.wu.framework.core.stereotype.MethodParamFunctionException;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyDatabase;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyDynamicEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableInfo;
import org.wu.framework.lazy.orm.core.persistence.map.EasyHashMap;
import org.wu.framework.lazy.orm.core.source.adapter.SourceFactory;
import org.wu.framework.lazy.orm.core.source.mysql.MySQLLazyTableInfo;
import org.wu.framework.lazy.orm.database.lambda.domain.LazyPage;
import org.wu.framework.lazy.orm.database.lambda.dynamic.toolkit.DynamicLazyDSContextHolder;
import org.wu.framework.lazy.orm.database.lambda.stream.lambda.LazyLambdaStream;
import org.wu.framework.lazy.orm.database.sql.smart.database.AbstractSmartLazyOperationSaveSql;
import org.wu.framework.lazy.orm.database.sql.smart.database.Perfect;
import org.wu.framework.lazy.orm.database.sql.smart.database.SmartLazyOperation;
import org.wu.framework.lazy.orm.database.sql.smart.database.SmartLazyOperationAutoStuffed;
import org.wu.framework.lazy.orm.database.toolkit.LazyCureContextHolder;
import org.wu.framework.translation.data.ProcessException;

public class LazySmartLazyOperation
extends AbstractSmartLazyOperationSaveSql
implements SmartLazyOperation {
    private final SmartLazyOperationAutoStuffed autoStuffedLazyOperation;
    private final Perfect perfect;
    private final LazyLambdaStream lazyLambdaStream;
    ThreadPoolExecutor LAZY_SMART_EXECUTOR = new ThreadPoolExecutor(5, 10, 200L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(20));

    public LazySmartLazyOperation(SmartLazyOperationAutoStuffed autoStuffedLazyOperation, Perfect perfect, LazyLambdaStream lazyLambdaStream) {
        this.autoStuffedLazyOperation = autoStuffedLazyOperation;
        this.perfect = perfect;
        this.lazyLambdaStream = lazyLambdaStream;
    }

    @Override
    protected LazyLambdaStream getLazyLambdaStream() {
        return this.lazyLambdaStream;
    }

    @Override
    public File saveSqlFile(String nameDatabase) {
        LazyDynamicEndpoint peek = DynamicLazyDSContextHolder.peek();
        Future<File> submit = this.LAZY_SMART_EXECUTOR.submit(() -> {
            try {
                if (peek != null) {
                    DynamicLazyDSContextHolder.push((LazyDynamicEndpoint)peek);
                }
                LazyCureContextHolder.push((Integer)0);
                File file = this.perfect.saveSqlFile(nameDatabase);
                return file;
            }
            catch (IOException | InterruptedException | SQLException | ExecutionException | MethodParamFunctionException | ProcessException e) {
                e.printStackTrace();
            }
            finally {
                DynamicLazyDSContextHolder.clear();
            }
            return null;
        });
        try {
            return submit.get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public File saveSoftSqlFile(String nameDatabase) {
        LazyDynamicEndpoint peek = DynamicLazyDSContextHolder.peek();
        Future<File> submit = this.LAZY_SMART_EXECUTOR.submit(() -> {
            try {
                if (peek != null) {
                    DynamicLazyDSContextHolder.push((LazyDynamicEndpoint)peek);
                }
                LazyCureContextHolder.push((Integer)0);
                return this.perfect.saveSoftSqlFile(nameDatabase);
            }
            catch (IOException | InterruptedException | SQLException | ExecutionException | MethodParamFunctionException | ProcessException e) {
                e.printStackTrace();
                return null;
            }
        });
        try {
            return submit.get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public File saveUpsertSqlFile(String nameDatabase) {
        LazyDynamicEndpoint peek = DynamicLazyDSContextHolder.peek();
        Future<File> submit = this.LAZY_SMART_EXECUTOR.submit(() -> {
            try {
                if (peek != null) {
                    DynamicLazyDSContextHolder.push((LazyDynamicEndpoint)peek);
                }
                LazyCureContextHolder.push((Integer)0);
                return this.perfect.saveUpsertSqlFile(nameDatabase);
            }
            catch (IOException | InterruptedException | SQLException | ExecutionException | MethodParamFunctionException | ProcessException e) {
                e.printStackTrace();
                return null;
            }
        });
        try {
            return submit.get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void stuffed(String schema, String table, Long num) {
        this.LAZY_SMART_EXECUTOR.execute(() -> this.autoStuffedLazyOperation.stuffed(schema, table, num));
    }

    @Override
    public void stuffed(Class table, Long num) {
        this.LAZY_SMART_EXECUTOR.execute(() -> this.autoStuffedLazyOperation.stuffed(table, num));
    }

    @Override
    public void stuffed(LazyTableInfo table, Long num) {
        LazyDynamicEndpoint peek = DynamicLazyDSContextHolder.peek();
        this.LAZY_SMART_EXECUTOR.execute(() -> {
            DynamicLazyDSContextHolder.push((LazyDynamicEndpoint)peek);
            this.autoStuffedLazyOperation.stuffed(table, num);
        });
    }

    @Override
    public void stuffedAll(Long num) {
        for (LazyDatabase showDatabase : this.perfect.showDatabases()) {
            System.out.println("\u8ba1\u5212\u6267\u884c\u6570\u636e\u5e93\u586b\u5145" + showDatabase.getDatabase());
            for (LazyTableInfo lazyTableInfo : this.perfect.showTables(showDatabase.getDatabase())) {
                this.LAZY_SMART_EXECUTOR.execute(() -> this.autoStuffedLazyOperation.stuffed(showTable, num));
            }
        }
    }

    @Override
    public void stuffedJava(String schema, String tableName) {
        this.autoStuffedLazyOperation.stuffedJava(schema, tableName);
    }

    @Override
    public List<LazyDatabase> showDatabases() {
        return this.perfect.showDatabases();
    }

    @Override
    public List<MySQLLazyTableInfo> showTables(String schema) {
        return this.perfect.showTables(schema);
    }

    @Override
    public void scrollTableData(String tableName, Consumer<LazyPage<EasyHashMap>> consumer) {
        this.lazyLambdaStream.scroll(null, EasyHashMap.class, "select * from %s", consumer, new Object[]{SourceFactory.cleanSpecialColumn((String)tableName)});
    }

    @Override
    public void scrollTableData(String tableName, LazyPage lazyPage, Consumer<LazyPage<EasyHashMap>> consumer) {
        this.lazyLambdaStream.scroll(lazyPage, EasyHashMap.class, "select * from %s", consumer, new Object[]{SourceFactory.cleanSpecialColumn((String)tableName)});
    }
}

