/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.interceptor;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableEndpoint;
import org.wu.framework.lazy.orm.core.persistence.util.LazySQLUtil;
import org.wu.framework.lazy.orm.core.source.adapter.SourceFactory;
import org.wu.framework.lazy.orm.database.lambda.domain.PersistenceRepository;
import org.wu.framework.lazy.orm.database.lambda.stream.LambdaTableType;
import org.wu.framework.lazy.orm.database.lambda.stream.condition.part.SqlPart;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.interceptor.AbstractSqlInterceptor;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.interceptor.tenant.LazyTenantLineHandler;

public class TenantIdSqlInterceptor
extends AbstractSqlInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantIdSqlInterceptor.class);
    private final LazyTenantLineHandler lazyTenantLineHandler;

    public TenantIdSqlInterceptor(LazyTenantLineHandler lazyTenantLineHandler) {
        this.lazyTenantLineHandler = lazyTenantLineHandler;
    }

    @Override
    protected void beforeInsertInterceptor(PersistenceRepository persistenceRepository) {
        List<String> tableList = this.tableInterceptor(persistenceRepository);
        for (String table : tableList) {
            boolean ignoreTable = this.lazyTenantLineHandler.ignoreTable(table);
            if (!ignoreTable) continue;
            return;
        }
        String tenantIdColumn = this.lazyTenantLineHandler.tenantIdColumn();
        String tenantId = this.lazyTenantLineHandler.getTenantId();
        ConcurrentMap tableCache = SourceFactory.getClassTableCache();
        List currentLazyTableEndpointList = tableCache.values().stream().collect(Collectors.toList());
        SqlPart sqlPart = persistenceRepository.getSqlPart();
        long count = currentLazyTableEndpointList.stream().filter(lazyTableEndpoint -> tableList.contains(lazyTableEndpoint.getTableName())).filter(lazyTableEndpoint -> lazyTableEndpoint.getLazyTableFieldEndpointList().stream().anyMatch(lazyTableFieldEndpoint -> tenantIdColumn.equals(lazyTableFieldEndpoint.getColumnName()))).count();
        if (count > 0L) {
            List newInsert = sqlPart.getInsert().stream().peek(stringObjectHashMap -> stringObjectHashMap.put(tenantIdColumn, LazySQLUtil.valueToSqlValue((Object)tenantId))).collect(Collectors.toList());
            sqlPart.setInsert(newInsert);
            PersistenceRepository newPersistenceRepository = sqlPart.persistenceRepository();
            String newSql = newPersistenceRepository.getBeforeQueryString();
            persistenceRepository.setQueryString(newSql);
        }
    }

    @Override
    protected void beforeDeleteInterceptor(PersistenceRepository persistenceRepository) {
        this.intercept(persistenceRepository);
    }

    @Override
    protected void beforeUpdateInterceptor(PersistenceRepository persistenceRepository) {
        this.intercept(persistenceRepository);
    }

    private void intercept(PersistenceRepository persistenceRepository) {
        List<String> tableList = this.tableInterceptor(persistenceRepository);
        for (String table : tableList) {
            boolean ignoreTable = this.lazyTenantLineHandler.ignoreTable(table);
            if (!ignoreTable) continue;
            return;
        }
        String tenantIdColumn = this.lazyTenantLineHandler.tenantIdColumn();
        String tenantId = this.lazyTenantLineHandler.getTenantId();
        ConcurrentMap tableCache = SourceFactory.getClassTableCache();
        List currentLazyTableEndpointList = tableCache.values().stream().collect(Collectors.toList());
        SqlPart sqlPart = persistenceRepository.getSqlPart();
        if (ObjectUtils.isEmpty((Object)sqlPart)) {
            log.warn("sqlPart is empty with : {}", (Object)persistenceRepository);
            return;
        }
        List lazyTableEndpointList = currentLazyTableEndpointList.stream().filter(lazyTableEndpoint -> tableList.contains(lazyTableEndpoint.getTableName())).filter(lazyTableEndpoint -> lazyTableEndpoint.getLazyTableFieldEndpointList().stream().anyMatch(lazyTableFieldEndpoint -> tenantIdColumn.equals(lazyTableFieldEndpoint.getColumnName()))).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<LazyTableEndpoint>(Comparator.comparing(LazyTableEndpoint::getTableName))), ArrayList::new));
        for (LazyTableEndpoint lazyTableEndpoint2 : lazyTableEndpointList) {
            sqlPart.put((Object)(lazyTableEndpoint2.getTableName() + "." + tenantIdColumn), "=", (Object)tenantId);
        }
        PersistenceRepository newPersistenceRepository = sqlPart.persistenceRepository();
        String newSql = newPersistenceRepository.getBeforeQueryString();
        persistenceRepository.setQueryString(newSql);
    }

    @Override
    protected void beforeSelectInterceptor(PersistenceRepository persistenceRepository) {
        this.intercept(persistenceRepository);
    }

    @Override
    public boolean support(PersistenceRepository persistenceRepository) {
        if (ObjectUtils.isEmpty((Object)persistenceRepository)) {
            return false;
        }
        LambdaTableType executionType = persistenceRepository.getExecutionType();
        return executionType.equals((Object)LambdaTableType.INSERT) || executionType.equals((Object)LambdaTableType.UPSERT) || executionType.equals((Object)LambdaTableType.DELETE) || executionType.equals((Object)LambdaTableType.UPDATE) || executionType.equals((Object)LambdaTableType.SELECT) || executionType.equals((Object)LambdaTableType.BATCH);
    }
}

