/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.interceptor;

import org.wu.framework.lazy.orm.database.lambda.domain.PersistenceRepository;
import org.wu.framework.lazy.orm.database.lambda.stream.LambdaTableType;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.interceptor.AbstractSqlTableInterceptor;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.interceptor.IgnoreSqlInterceptorContextHolder;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.interceptor.SqlInterceptor;

public abstract class AbstractSqlInterceptor
extends AbstractSqlTableInterceptor
implements SqlInterceptor {
    protected abstract void beforeInsertInterceptor(PersistenceRepository var1);

    protected abstract void beforeDeleteInterceptor(PersistenceRepository var1);

    protected abstract void beforeUpdateInterceptor(PersistenceRepository var1);

    protected abstract void beforeSelectInterceptor(PersistenceRepository var1);

    @Override
    public void interceptor(PersistenceRepository persistenceRepository) {
        LambdaTableType executionType = persistenceRepository.getExecutionType();
        if (Boolean.TRUE.equals(IgnoreSqlInterceptorContextHolder.peek())) {
            return;
        }
        if (LambdaTableType.INSERT == executionType || LambdaTableType.UPSERT == executionType || LambdaTableType.UPSERT_REMOVE_NULL == executionType) {
            this.beforeInsertInterceptor(persistenceRepository);
        } else if (LambdaTableType.DELETE == executionType) {
            this.beforeDeleteInterceptor(persistenceRepository);
        } else if (LambdaTableType.UPDATE == executionType) {
            this.beforeUpdateInterceptor(persistenceRepository);
        } else if (LambdaTableType.SELECT == executionType || LambdaTableType.BATCH == executionType) {
            this.beforeSelectInterceptor(persistenceRepository);
        }
    }
}

