/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.dql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.persistence.util.SqlMessageFormatUtil;
import org.wu.framework.lazy.orm.database.lambda.domain.PersistenceRepository;
import org.wu.framework.lazy.orm.database.lambda.stream.LambdaTableType;
import org.wu.framework.lazy.orm.database.lambda.stream.condition.part.SqlPart;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.LazyOperationParameter;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.dql.AbstractLazyDQLOperationMethod;
import org.wu.framework.lazy.orm.database.sql.util.SqlColumnUtils;
import org.wu.framework.lazy.orm.database.sql.util.SqlUtils;

public class LazyOperationMethodExecuteSQL
extends AbstractLazyDQLOperationMethod {
    public LazyOperationMethodExecuteSQL(LazyOperationParameter lazyOperationParameter) {
        super(lazyOperationParameter);
    }

    @Override
    public PersistenceRepository doAnalyzePersistenceRepository(Object[] sourceParams) throws Exception {
        Object[] p = sourceParams;
        String sourceSql = (String)p[0];
        Class clazz = (Class)p[1];
        Object[] params = (Object[])p[2];
        String sql = ObjectUtils.isEmpty((Object)params) ? sourceSql : SqlMessageFormatUtil.format((String)sourceSql, (Object[])params);
        sql = sql.trim();
        SqlPart sqlPartFromSql = SqlUtils.createSqlPartFromSql(sql);
        PersistenceRepository persistenceRepository = this.createPersistenceRepository();
        LambdaTableType lambdaTableType = SqlColumnUtils.executeTypeInSql(sql);
        persistenceRepository.setExecutionType(lambdaTableType);
        persistenceRepository.setQueryString(sql);
        persistenceRepository.setResultClass(clazz);
        persistenceRepository.setSqlPart(sqlPartFromSql);
        sqlPartFromSql.setPersistenceRepository(persistenceRepository);
        return persistenceRepository;
    }

    @Override
    public Object doExecute(Connection connection, Object[] sourceParams) throws SQLException, NoSuchFieldException, InstantiationException, IllegalAccessException {
        PersistenceRepository persistenceRepository = null;
        try {
            persistenceRepository = this.analyzePersistenceRepository(sourceParams);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String sql = persistenceRepository.getQueryString();
        try (PreparedStatement preparedStatement = connection.prepareStatement(sql);){
            if (persistenceRepository.getExecutionType().equals((Object)LambdaTableType.SELECT)) {
                ResultSet resultSet = preparedStatement.executeQuery();
                List list = this.resultSetConverter(resultSet, persistenceRepository.getResultType());
                return list;
            }
            if (persistenceRepository.getExecutionType().equals((Object)LambdaTableType.UPDATE)) {
                int n = preparedStatement.executeUpdate();
                this.sendLazyOrmEvent(LambdaTableType.UPDATE, sql);
                List<Integer> list = Arrays.asList(n);
                return list;
            }
            if (persistenceRepository.getExecutionType().equals((Object)LambdaTableType.DELETE)) {
                int n = preparedStatement.executeUpdate();
                this.sendLazyOrmEvent(LambdaTableType.DELETE, sql);
                List<Integer> list = Arrays.asList(n);
                return list;
            }
            if (persistenceRepository.getExecutionType().equals((Object)LambdaTableType.INSERT)) {
                this.sendLazyOrmEvent(LambdaTableType.INSERT, sql);
                int n = preparedStatement.executeUpdate();
                List<Integer> list = Arrays.asList(n);
                return list;
            }
            for (String s : sql.split(";")) {
                preparedStatement.addBatch(s);
            }
            preparedStatement.executeLargeBatch();
            Boolean bl = true;
            return bl;
        }
    }
}

