/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.ddl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wu.framework.lazy.orm.core.config.enums.DDLAuto;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableEndpoint;
import org.wu.framework.lazy.orm.core.source.SqlSourceClass;
import org.wu.framework.lazy.orm.database.lambda.domain.PersistenceRepository;
import org.wu.framework.lazy.orm.database.lambda.stream.LambdaTableType;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.LazyOperationParameter;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.ddl.AbstractLazyDDLOperationMethod;

public class LazyOperationMethodCreateTable
extends AbstractLazyDDLOperationMethod {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LazyOperationMethodCreateTable.class);

    public LazyOperationMethodCreateTable(LazyOperationParameter lazyOperationParameter) {
        super(lazyOperationParameter);
    }

    @Override
    public PersistenceRepository doAnalyzePersistenceRepository(Object[] sourceParams) throws Exception {
        PersistenceRepository persistenceRepository = this.createPersistenceRepository();
        persistenceRepository.setExecutionType(LambdaTableType.DDL);
        ArrayList<Class> classes = new ArrayList<Class>();
        for (Object sourceParam : sourceParams) {
            if (sourceParam instanceof Object[]) {
                Object[] objects;
                for (Object o : objects = (Object[])sourceParam) {
                    Class entityClass = (Class)o;
                    classes.add(entityClass);
                }
                continue;
            }
            Class entityClass = (Class)sourceParam;
            classes.add(entityClass);
        }
        String tables = classes.stream().map(clazz -> {
            SqlSourceClass sqlSourceClass = SqlSourceClass.getInstance((Class)clazz);
            return sqlSourceClass.getLazyTableEndpoint().getTableName();
        }).collect(Collectors.joining("\u3001"));
        persistenceRepository.setQueryString("\u6267\u884c\u521b\u5efa\u8868[" + tables + "]\u7ed3\u6784sql");
        return persistenceRepository;
    }

    @Override
    public Object doExecute(Connection connection, Object[] sourceParams) throws Exception {
        Object param = sourceParams[0];
        if (param instanceof Object[]) {
            Object[] objects;
            for (Object o : objects = (Object[])param) {
                Class entityClass = (Class)o;
                this.create(entityClass, connection);
            }
        } else {
            Class entityClass = (Class)param;
            this.create(entityClass, connection);
        }
        return true;
    }

    protected void create(Class<?> entityClass, Connection connection) throws SQLException, NoSuchFieldException, InstantiationException, IllegalAccessException {
        SqlSourceClass sqlSourceClass = SqlSourceClass.getInstance(entityClass);
        LazyTableEndpoint lazyTableEndpoint = sqlSourceClass.getLazyTableEndpoint();
        this.perfect(connection, entityClass, DDLAuto.UPDATE);
        log.warn("create table {} success", (Object)lazyTableEndpoint.getFullTableName());
    }
}

