/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.ddl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wu.framework.core.stereotype.LayerField;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.config.enums.DDLAuto;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyColumn;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyColumnIndex;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyDatabaseJsonMessage;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableFieldEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableIndexEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableInfo;
import org.wu.framework.lazy.orm.core.persistence.conf.index.AbstractLazyTableIndexEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.mysql.ClassLazyTableEndpoint;
import org.wu.framework.lazy.orm.core.persistence.map.EasyHashMap;
import org.wu.framework.lazy.orm.core.source.SqlSourceClass;
import org.wu.framework.lazy.orm.core.source.adapter.SourceFactory;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.AbstractLazyOperationMethod;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.LazyOperationParameter;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.ddl.LazyDDLOperationMethod;

public abstract class AbstractLazyDDLOperationMethod
extends AbstractLazyOperationMethod
implements LazyDDLOperationMethod {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractLazyDDLOperationMethod.class);

    public AbstractLazyDDLOperationMethod(LazyOperationParameter lazyOperationParameter) {
        super(lazyOperationParameter);
    }

    public synchronized boolean perfect(Connection connection, EasyHashMap easyHashMap) throws SQLException, NoSuchFieldException, InstantiationException, IllegalAccessException {
        ClassLazyTableEndpoint lazyTableEndpoint = easyHashMap.toEasyTableAnnotation(false, true);
        return this.perfect(connection, (LazyTableEndpoint)lazyTableEndpoint);
    }

    public synchronized boolean perfect(Connection connection, Class entityClass, DDLAuto ddlAuto) throws SQLException, NoSuchFieldException, InstantiationException, IllegalAccessException {
        if (LazyDatabaseJsonMessage.localCacheEntityClass.contains(entityClass)) {
            return true;
        }
        if (!EasyHashMap.class.isAssignableFrom(entityClass)) {
            LazyDatabaseJsonMessage.localCacheEntityClass.add(entityClass);
        }
        SqlSourceClass sqlSourceClass = SqlSourceClass.getInstance((Class)entityClass);
        LazyTableEndpoint lazyTableEndpoint = sqlSourceClass.getLazyTableEndpoint();
        return this.perfect(connection, lazyTableEndpoint, ddlAuto);
    }

    public synchronized boolean perfect(Connection connection, LazyTableEndpoint lazyTableEndpoint) throws SQLException, NoSuchFieldException, InstantiationException, IllegalAccessException {
        return this.perfect(connection, lazyTableEndpoint, DDLAuto.PERFECT);
    }

    public synchronized boolean perfect(Connection connection, LazyTableEndpoint lazyTableEndpoint, DDLAuto ddlAuto) throws SQLException, NoSuchFieldException, InstantiationException, IllegalAccessException {
        boolean exist = lazyTableEndpoint.isExist();
        if (exist) {
            Statement statement = connection.createStatement();
            List<LazyTableInfo> lazyTableInfos = this.findTableInfo(connection, lazyTableEndpoint);
            if (ObjectUtils.isEmpty(lazyTableInfos)) {
                String createTableSQL = lazyTableEndpoint.creatTableSQL();
                for (String sql : createTableSQL.split(";")) {
                    statement.execute(sql);
                }
                log.warn("create table {} success", (Object)lazyTableEndpoint.getTableName());
            }
            if (!DDLAuto.CREATE.equals((Object)ddlAuto)) {
                List<LazyColumn> lazyColumnCollection = this.findTableColumnList(connection, lazyTableEndpoint);
                List<LazyColumnIndex> lazyColumnIndexList = this.findTableColumnIndexList(connection, lazyTableEndpoint);
                Map<String, List<LazyColumnIndex>> columnIndexMap = lazyColumnIndexList.stream().collect(Collectors.groupingBy(LazyColumnIndex::getColumnName));
                ArrayList<LazyTableFieldEndpoint> currentColumnNameList = new ArrayList<LazyTableFieldEndpoint>();
                for (LazyColumn lazyColumn : lazyColumnCollection) {
                    LazyTableFieldEndpoint oldFieldLazyTableFieldEndpoint = SourceFactory.getDefaultLazyTableFieldEndpointInstance();
                    oldFieldLazyTableFieldEndpoint.setColumnName(lazyColumn.getColumnName());
                    oldFieldLazyTableFieldEndpoint.setDefaultValue(lazyColumn.getColumnDefault());
                    oldFieldLazyTableFieldEndpoint.setNotNull(!"yes".equalsIgnoreCase(lazyColumn.getIsNullable()));
                    oldFieldLazyTableFieldEndpoint.setDataType(lazyColumn.getDataType());
                    oldFieldLazyTableFieldEndpoint.setScale(lazyColumn.getNumericScale());
                    oldFieldLazyTableFieldEndpoint.setColumnType(lazyColumn.getColumnType());
                    oldFieldLazyTableFieldEndpoint.setExtra(lazyColumn.getExtra());
                    oldFieldLazyTableFieldEndpoint.setComment(lazyColumn.getColumnComment());
                    if (columnIndexMap.containsKey(lazyColumn.getColumnName())) {
                        List<LazyColumnIndex> lazyColumnIndexs = columnIndexMap.get(lazyColumn.getColumnName());
                        LazyTableIndexEndpoint[] indexEndpoints = lazyColumnIndexs.stream().map(lazyColumnIndex -> {
                            AbstractLazyTableIndexEndpoint instance = AbstractLazyTableIndexEndpoint.getInstance();
                            instance.setIndexName(lazyColumnIndex.getIndexName());
                            instance.setFieldIndexType(lazyColumnIndex.isNonUnique() ? LayerField.LayerFieldType.NORMAL : LayerField.LayerFieldType.UNIQUE);
                            return instance;
                        }).collect(Collectors.toList()).toArray(new LazyTableIndexEndpoint[0]);
                        oldFieldLazyTableFieldEndpoint.setLazyTableIndexEndpoints(indexEndpoints);
                        oldFieldLazyTableFieldEndpoint.setKey(lazyColumnIndexs.stream().anyMatch(lazyColumnIndex -> "PRIMARY".equals(lazyColumnIndex.getIndexName())));
                    }
                    currentColumnNameList.add(oldFieldLazyTableFieldEndpoint);
                }
                String alterTableSQL = null;
                boolean dropColumn = DDLAuto.PERFECT.equals((Object)ddlAuto);
                alterTableSQL = lazyTableEndpoint.alterTableSQL(currentColumnNameList, dropColumn);
                if (!ObjectUtils.isEmpty((Object)alterTableSQL)) {
                    log.debug("alter table sql:{}", (Object)alterTableSQL);
                    try {
                        boolean oldFieldLazyTableFieldEndpoint = statement.execute(alterTableSQL);
                    }
                    catch (SQLException e) {
                        List alterTableColumnSQL = lazyTableEndpoint.alterTableColumnSQL(currentColumnNameList, dropColumn);
                        for (String alertTableColumn : alterTableColumnSQL) {
                            try {
                                statement.execute(alertTableColumn);
                            }
                            catch (Exception exception) {
                                log.warn("\u6267\u884c \u5355\u4e2a\u5b57\u6bb5\u66f4\u65b0 sql: " + alertTableColumn + "\n\u5931\u8d25: " + exception);
                            }
                        }
                        throw new SQLException("\u6267\u884csql \u5931\u8d25: " + alterTableSQL, e);
                    }
                } else {
                    log.info("\u8868\u7ed3\u6784\u672a\u53d1\u751f\u53d8\u5316");
                }
            }
            statement.close();
            return true;
        }
        log.warn("Ignore creating tables:" + lazyTableEndpoint.getTableName());
        return false;
    }

    @Override
    public List<String> findSchemaList(Connection connection) {
        Statement statement = null;
        try {
            List<String> schemaList;
            statement = connection.createStatement();
            String schemaListSql = SourceFactory.findSchemaListSql();
            ResultSet resultSet = statement.executeQuery(schemaListSql);
            List<String> list = schemaList = this.resultSetConverter(resultSet, String.class);
            return list;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException | SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public List<LazyColumn> findTableColumnList(Connection connection, LazyTableEndpoint lazyTableEndpoint) {
        Statement statement = null;
        try {
            List<LazyColumn> lazyColumnList;
            String schema = ObjectUtils.isEmpty((Object)lazyTableEndpoint.getSchema()) ? (ObjectUtils.isEmpty((Object)connection.getCatalog()) ? connection.getSchema() : connection.getCatalog()) : lazyTableEndpoint.getSchema();
            String table = SourceFactory.cleanSpecialColumn((String)lazyTableEndpoint.getTableName());
            statement = connection.createStatement();
            String findTableColumnListSql = SourceFactory.findTableColumnListSql((String)schema, (String)table);
            ResultSet resultSet = statement.executeQuery(findTableColumnListSql);
            Class columnInfoClass = SourceFactory.findColumnInfoClass();
            List<LazyColumn> list = lazyColumnList = this.resultSetConverter(resultSet, columnInfoClass);
            return list;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException | SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public List<LazyColumnIndex> findTableColumnIndexList(Connection connection, LazyTableEndpoint lazyTableEndpoint) {
        Statement statement = null;
        try {
            List<LazyColumnIndex> lazyColumnIndexList;
            String schema = ObjectUtils.isEmpty((Object)lazyTableEndpoint.getSchema()) ? (ObjectUtils.isEmpty((Object)connection.getCatalog()) ? connection.getSchema() : connection.getCatalog()) : lazyTableEndpoint.getSchema();
            String table = SourceFactory.cleanSpecialColumn((String)lazyTableEndpoint.getTableName());
            statement = connection.createStatement();
            String findTableColumnIndexListSql = SourceFactory.findTableColumnIndexListSql((String)schema, (String)table);
            if (ObjectUtils.isEmpty((Object)findTableColumnIndexListSql)) {
                List<LazyColumnIndex> list = Arrays.asList(new LazyColumnIndex[0]);
                return list;
            }
            ResultSet resultSet = statement.executeQuery(findTableColumnIndexListSql);
            Class columnIndexInfoClass = SourceFactory.findColumnIndexInfoClass();
            List<LazyColumnIndex> list = lazyColumnIndexList = this.resultSetConverter(resultSet, columnIndexInfoClass);
            return list;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException | SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public List<LazyTableInfo> findTableInfo(Connection connection, LazyTableEndpoint lazyTableEndpoint) {
        Statement statement = null;
        try {
            List<LazyTableInfo> lazyTableInfoList;
            String schema = ObjectUtils.isEmpty((Object)lazyTableEndpoint.getSchema()) ? (ObjectUtils.isEmpty((Object)connection.getCatalog()) ? connection.getSchema() : connection.getCatalog()) : lazyTableEndpoint.getSchema();
            String table = SourceFactory.cleanSpecialColumn((String)lazyTableEndpoint.getTableName());
            statement = connection.createStatement();
            String findTableInfoSql = SourceFactory.findTableInfoSql((String)schema, (String)table);
            ResultSet resultSet = statement.executeQuery(findTableInfoSql);
            Class tableInfoClass = SourceFactory.findTableInfoClass();
            List<LazyTableInfo> list = lazyTableInfoList = this.resultSetConverter(resultSet, tableInfoClass);
            return list;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException | SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public void alertTable(LazyTableEndpoint lazyTableEndpoint) {
    }
}

