/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.sql.expand.database.persistence.factory;

import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.config.LazyOperationAttribute;
import org.wu.framework.lazy.orm.core.config.enums.LazyDataSourceType;
import org.wu.framework.lazy.orm.core.config.prop.DefaultLazyDataSourceAttribute;
import org.wu.framework.lazy.orm.core.config.prop.LazyDataSourceAttribute;
import org.wu.framework.lazy.orm.core.source.adapter.SourceFactory;
import org.wu.framework.lazy.orm.database.lambda.domain.PersistenceRepository;
import org.wu.framework.lazy.orm.database.lambda.domain.PersistenceRepositoryFactory;
import org.wu.framework.lazy.orm.database.lambda.dynamic.LazyDynamicDatasourceAdapter;
import org.wu.framework.lazy.orm.database.lambda.dynamic.factory.LazyDynamicAdapterFactory;
import org.wu.framework.lazy.orm.database.lambda.dynamic.toolkit.DynamicLazyDSContextHolder;
import org.wu.framework.lazy.orm.database.lambda.stream.LambdaTableType;
import org.wu.framework.lazy.orm.database.lambda.stream.lambda.LazyLambdaStream;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.LazySqlOperation;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.cure.CureAdapter;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.cure.CureAdapterFactory;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.factory.LazyLambdaStreamFactory;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.factory.LazyOperationMethodFactory;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.factory.LazyOperationProxyFactory;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.LazyOperationMethod;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.proxy.LazyOperationProxy;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.translation.adapter.LazyTranslationAdapter;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.translation.factory.LazyTranslationAdapterFactory;

public class LazyDataSourcePropertiesFactory {
    public static Logger log = LoggerFactory.getLogger(LazyDataSourcePropertiesFactory.class);

    public static LazyDataSourceAttribute createLazyDataSourceProperties(String url, String username, String password) {
        DefaultLazyDataSourceAttribute lazyDataSourceAttribute = new DefaultLazyDataSourceAttribute();
        lazyDataSourceAttribute.setUrl(url);
        lazyDataSourceAttribute.setUsername(username);
        lazyDataSourceAttribute.setPassword(password);
        return lazyDataSourceAttribute;
    }

    public static LazyDataSourceAttribute createLazyDataSourceProperties(String url, String username, String password, Class<? extends DataSource> type, String alias) {
        DefaultLazyDataSourceAttribute lazyDataSourceAttribute = new DefaultLazyDataSourceAttribute();
        lazyDataSourceAttribute.setUrl(url);
        lazyDataSourceAttribute.setUsername(username);
        lazyDataSourceAttribute.setPassword(password);
        lazyDataSourceAttribute.setType(type);
        lazyDataSourceAttribute.setAlias(alias);
        return lazyDataSourceAttribute;
    }

    public static void initSchema(LazyDataSourceAttribute lazyDataSourceAttribute, LazyOperationAttribute lazyOperationAttribute) {
        String url = lazyDataSourceAttribute.getUrl();
        String username = lazyDataSourceAttribute.getUsername();
        String password = lazyDataSourceAttribute.getPassword();
        Class type = lazyDataSourceAttribute.getType();
        String defaultInformationSchemaUrl = SourceFactory.getDefaultInformationSchemaUrl((String)url);
        if (ObjectUtils.isEmpty((Object)defaultInformationSchemaUrl)) {
            return;
        }
        String tempDataSourceId = UUID.randomUUID().toString();
        LazyDataSourceAttribute tempLazyDataSourceAttribute = LazyDataSourcePropertiesFactory.createLazyDataSourceProperties(defaultInformationSchemaUrl, username, password, type, tempDataSourceId);
        List<LazyOperationMethod> defaultLazyOperationMethod = LazyOperationMethodFactory.createDefaultLazyOperationMethod(lazyOperationAttribute);
        LazyDynamicDatasourceAdapter lazyDynamicAdapter = LazyDynamicAdapterFactory.createLazyDynamicAdapter((LazyDataSourceAttribute)tempLazyDataSourceAttribute);
        CureAdapter cureAdapter = CureAdapterFactory.createCureAdapter(tempLazyDataSourceAttribute);
        LazyTranslationAdapter lazyTranslationAdapter = LazyTranslationAdapterFactory.createLazyTranslationAdapter();
        LazyOperationProxy defaultLazyOperationProxy = LazyOperationProxyFactory.createLazyOperationProxy(defaultLazyOperationMethod, lazyDynamicAdapter, cureAdapter, lazyTranslationAdapter);
        LazySqlOperation tempLazyOperation = LazyOperationProxyFactory.createLazyOperation(defaultLazyOperationProxy);
        LazyLambdaStream lazyLambdaStream = LazyLambdaStreamFactory.createLazyLambdaStream(tempLazyOperation);
        DynamicLazyDSContextHolder.switchDatasource((String)tempDataSourceId);
        String schema = SourceFactory.getUrlSchema((String)url);
        PersistenceRepository persistenceRepository = PersistenceRepositoryFactory.create();
        LazyDataSourceType lazyDataSourceType = SourceFactory.getLazyDataSourceType((String)url);
        String schemaSql = SourceFactory.createSchemaSql((LazyDataSourceType)lazyDataSourceType, (String)schema);
        persistenceRepository.setResultClass(Boolean.class);
        persistenceRepository.setExecutionType(LambdaTableType.CREATE);
        persistenceRepository.setQueryString(schemaSql);
        lazyLambdaStream.executeOne(persistenceRepository);
        log.info("\u521d\u59cb\u5316\u521b\u5efa\u6570\u636e\u5e93:\u3010{}\u3011", (Object)schema);
        lazyDynamicAdapter.closeDataSource(tempDataSourceId);
    }
}

