/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.sql.expand.database.persistence.audit;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wu.framework.lazy.database.datasource.proxy.audit.LazyAuditAdapter;
import org.wu.framework.lazy.database.datasource.proxy.sql.LazySQLContext;
import org.wu.framework.lazy.database.datasource.proxy.toolkit.AuditStatus;
import org.wu.framework.lazy.database.datasource.proxy.toolkit.DynamicLazySQLAuditStatusHolder;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyDynamicEndpoint;
import org.wu.framework.lazy.orm.database.lambda.dynamic.toolkit.DynamicLazyAuditDSContextHolder;
import org.wu.framework.lazy.orm.database.lambda.dynamic.toolkit.DynamicLazyDSContextHolder;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.audit.Audit;

public class AuditAdapter
implements LazyAuditAdapter {
    private final Logger log = LoggerFactory.getLogger(AuditAdapter.class);
    private final List<Audit> auditList;

    public AuditAdapter(List<Audit> auditList) {
        this.auditList = auditList;
    }

    public void setAuditList(List<Audit> auditList) {
        this.auditList.addAll(auditList);
    }

    public void audit(LazySQLContext lazySQLContext) {
        String sql = lazySQLContext.getSql();
        AuditStatus peek = DynamicLazySQLAuditStatusHolder.peek();
        LazyDynamicEndpoint lazyDynamicEndpoint = DynamicLazyDSContextHolder.peek();
        DynamicLazyDSContextHolder.clear();
        if (peek == null || AuditStatus.AUDIT.equals((Object)peek)) {
            DynamicLazyAuditDSContextHolder.push((LazyDynamicEndpoint)lazyDynamicEndpoint);
            this.auditList.forEach(audit -> {
                DynamicLazySQLAuditStatusHolder.push((AuditStatus)AuditStatus.NOT_AUDIT);
                if (audit.supports(lazySQLContext)) {
                    try {
                        audit.audit(lazySQLContext);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new RuntimeException("SQL \u5ba1\u8ba1\u5f02\u5e38" + sql);
                    }
                }
                DynamicLazySQLAuditStatusHolder.clear();
            });
            DynamicLazyAuditDSContextHolder.clear();
        }
        if (null != lazyDynamicEndpoint) {
            DynamicLazyDSContextHolder.push((LazyDynamicEndpoint)lazyDynamicEndpoint);
        }
    }
}

