/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.sql.util;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.wu.framework.lazy.orm.database.lambda.dynamic.toolkit.DynamicLazyDataSourceContextHolder;

public class LazyDataSourceUtils {
    public static Connection getConnection(DataSource dataSource) throws SQLException {
        Connection connection = dataSource.getConnection();
        DynamicLazyDataSourceContextHolder.push((DataSource)dataSource);
        return connection;
    }

    public static boolean isConnectionTransactional(Connection con, DataSource dataSource) {
        return false;
    }

    public static void releaseConnection(Connection connection, DataSource dataSource) throws SQLException {
        DynamicLazyDataSourceContextHolder.clear();
        if (!connection.isClosed()) {
            connection.close();
        }
    }
}

