/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.sql.smart.database.persistence;

import java.io.File;
import java.io.IOException;
import java.text.Collator;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wu.framework.core.CamelAndUnderLineConverter;
import org.wu.framework.core.exception.AssertFactory;
import org.wu.framework.core.stereotype.LayerField;
import org.wu.framework.core.utils.DataTransformUntil;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.config.DefaultLazyOperationAttribute;
import org.wu.framework.lazy.orm.core.config.LazyOperationAttribute;
import org.wu.framework.lazy.orm.core.config.ReverseEngineering;
import org.wu.framework.lazy.orm.core.config.enums.MysqlColumnTypeEnum;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyColumn;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyColumnIndex;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyDynamicEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableFieldEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableIndexEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableInfo;
import org.wu.framework.lazy.orm.core.persistence.conf.index.AbstractLazyTableIndexEndpoint;
import org.wu.framework.lazy.orm.core.persistence.map.EasyHashMap;
import org.wu.framework.lazy.orm.core.persistence.reverse.ReverseClassFactory;
import org.wu.framework.lazy.orm.core.persistence.reverse.ReverseClassLazyTableEndpoint;
import org.wu.framework.lazy.orm.core.source.SqlSourceClass;
import org.wu.framework.lazy.orm.core.source.adapter.SourceFactory;
import org.wu.framework.lazy.orm.core.source.mysql.MySQLLazyColumn;
import org.wu.framework.lazy.orm.core.source.mysql.MySQLLazyColumnIndex;
import org.wu.framework.lazy.orm.core.source.mysql.MySQLLazyTableInfo;
import org.wu.framework.lazy.orm.database.lambda.dynamic.toolkit.DynamicLazyDSContextHolder;
import org.wu.framework.lazy.orm.database.lambda.stream.condition.BasicComparison;
import org.wu.framework.lazy.orm.database.lambda.stream.lambda.LazyLambdaStream;
import org.wu.framework.lazy.orm.database.lambda.stream.wrapper.LazyWrappers;
import org.wu.framework.lazy.orm.database.sql.smart.database.SmartLazyOperationAutoStuffed;

public class LazyOperationSmartAutoStuffed
implements SmartLazyOperationAutoStuffed {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LazyOperationSmartAutoStuffed.class);
    public final LazyLambdaStream lazyLambdaStream;
    private final LazyOperationAttribute operationConfig;
    ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(5, 20, 20L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(20), new ThreadPoolExecutor.CallerRunsPolicy());

    public LazyOperationSmartAutoStuffed(LazyLambdaStream lazyLambdaStream) {
        this.lazyLambdaStream = lazyLambdaStream;
        this.operationConfig = new DefaultLazyOperationAttribute();
    }

    public LazyOperationSmartAutoStuffed(LazyOperationAttribute operationConfig, LazyLambdaStream lazyLambdaStream) {
        this.operationConfig = operationConfig;
        this.lazyLambdaStream = lazyLambdaStream;
    }

    private void stuffedSimple(LazyTableInfo table, List<LazyColumn> lazyColumnList, Long num) {
        AssertFactory.notNull((Object)num, (String)"'num' must not be null ");
        if (this.operationConfig.getIgnoredDatabase().contains(table.getTableSchema())) {
            log.warn("\u53d7\u4fdd\u62a4\u7684\u6570\u636e\u5e93:{}\u4e0d\u4f1a\u81ea\u52a8\u586b\u5145,\u66f4\u591a\u914d\u7f6e\u53c2\u8003\u914d\u7f6e\u6587\u4ef6\u6dfb\u52a0 spring.lazy.ignored-database:{} ", (Object)table.getTableSchema(), (Object)this.operationConfig.getIgnoredDatabase());
            return;
        }
        String schema = table.getTableSchema();
        String tableName = table.getTableName();
        if (ObjectUtils.isEmpty(lazyColumnList)) {
            return;
        }
        ArrayList<EasyHashMap> list = new ArrayList<EasyHashMap>();
        int i = 0;
        while ((long)i <= num) {
            EasyHashMap objectObjectEasyHashMap = new EasyHashMap(schema + "." + tableName);
            objectObjectEasyHashMap.setKeyAdjust(false);
            for (LazyColumn lazyColumn : lazyColumnList) {
                String columnName = lazyColumn.getColumnName();
                Long characterMaximumLength = lazyColumn.getCharacterMaximumLength();
                String extra = lazyColumn.getExtra();
                String isNullable = lazyColumn.getIsNullable();
                if ("auto_increment".equals(extra) || this.operationConfig.getFillIgnoredFields().contains(columnName) && "YES".equals(isNullable)) continue;
                String columnDataType = lazyColumn.getDataType();
                MysqlColumnTypeEnum mysqlColumnTypeEnum = (MysqlColumnTypeEnum)MysqlColumnTypeEnum.MYSQL_COLUMN_TYPE_ENUM_MAP.get(columnDataType);
                if (null == mysqlColumnTypeEnum) {
                    log.warn("\u81ea\u52a8\u586b\u5145\u6570\u636eschema:{} tableName:{} \u65e0\u6cd5\u627e\u5230\u7c7b\u578b{}\uff0c\u5f53\u524d\u5b57\u6bb5{}\u6570\u636e\u586b\u5145\u4e3anull", new Object[]{schema, tableName, columnDataType, columnName});
                    continue;
                }
                Class javaType = mysqlColumnTypeEnum.getJavaType();
                if (LocalDateTime.class.isAssignableFrom(javaType)) {
                    objectObjectEasyHashMap.put((Object)columnName, (Object)LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd hh:mm:ss")));
                    continue;
                }
                if (Date.class.isAssignableFrom(javaType)) {
                    objectObjectEasyHashMap.put((Object)columnName, (Object)LocalDate.now().format(DateTimeFormatter.ISO_LOCAL_DATE));
                    continue;
                }
                if (Date.class.isAssignableFrom(javaType)) {
                    objectObjectEasyHashMap.put((Object)columnName, (Object)LocalDate.now().format(DateTimeFormatter.ISO_LOCAL_DATE));
                    continue;
                }
                if (File.class.isAssignableFrom(javaType)) {
                    try {
                        objectObjectEasyHashMap.put((Object)columnName, (Object)File.createTempFile("smart-auto-stuffed-temp", "temp"));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (columnDataType.contains("varchar") || columnDataType.contains("char")) {
                    objectObjectEasyHashMap.put((Object)columnName, DataTransformUntil.simulationBaseBean((Class)javaType, (Integer)Math.toIntExact(characterMaximumLength)));
                } else {
                    objectObjectEasyHashMap.put((Object)columnName, DataTransformUntil.simulationBaseBean((Class)javaType, (Integer)mysqlColumnTypeEnum.getBound()));
                }
                if (!columnDataType.contains("decimal")) continue;
                objectObjectEasyHashMap.put((Object)columnName, (Object)0);
            }
            list.add(objectObjectEasyHashMap);
            ++i;
        }
        try {
            this.lazyLambdaStream.insert(list);
        }
        catch (Throwable throwable) {
            log.error("\u5f53\u524d\u6570\u636e\u63d2\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5f53\u524d\u6570\u636e\u5e93\u8868\u7ed3\u6784{}", lazyColumnList);
            throw throwable;
        }
    }

    @Override
    public void stuffed(LazyTableInfo table, Long num) {
        AssertFactory.notNull((Object)num, (String)"'num' must not be null ");
        if (this.operationConfig.getIgnoredDatabase().contains(table.getTableSchema())) {
            log.warn("\u53d7\u4fdd\u62a4\u7684\u6570\u636e\u5e93:{}\u4e0d\u4f1a\u81ea\u52a8\u586b\u5145,\u66f4\u591a\u914d\u7f6e\u53c2\u8003\u914d\u7f6e\u6587\u4ef6\u6dfb\u52a0 spring.lazy.ignored-database:{} ", (Object)table.getTableSchema(), (Object)this.operationConfig.getIgnoredDatabase());
            return;
        }
        String schema = table.getTableSchema();
        String tableName = table.getTableName();
        LazyDynamicEndpoint peek = DynamicLazyDSContextHolder.peek();
        ArrayList<LazyColumn> lazyColumnList = new ArrayList<LazyColumn>(this.lazyLambdaStream.selectList((BasicComparison)LazyWrappers.lambdaWrapper().eq(LazyColumn::getTableSchema, (Object)schema).eq(LazyColumn::getTableName, (Object)tableName)));
        if (ObjectUtils.isEmpty(lazyColumnList)) {
            return;
        }
        if (num > this.operationConfig.getFillMaximum()) {
            long time = num / this.operationConfig.getFillMaximum();
            long remainingSize = num % this.operationConfig.getFillMaximum();
            int i = 0;
            while ((long)i < time) {
                log.info("\u6267\u884c\u6b21\u6570:{},\u6dfb\u52a0\u7684\u6570\u636e\u5e93:{},\u8868:{}", new Object[]{i, schema, tableName});
                this.threadPoolExecutor.submit(() -> {
                    DynamicLazyDSContextHolder.push((LazyDynamicEndpoint)peek);
                    this.stuffedSimple(table, lazyColumnList, this.operationConfig.getFillMaximum());
                });
                ++i;
            }
            this.threadPoolExecutor.submit(() -> {
                DynamicLazyDSContextHolder.push((LazyDynamicEndpoint)peek);
                this.stuffedSimple(table, lazyColumnList, remainingSize);
            });
        } else {
            DynamicLazyDSContextHolder.push((LazyDynamicEndpoint)peek);
            this.stuffedSimple(table, lazyColumnList, num);
        }
    }

    @Override
    public <T> void stuffed(Class<T> tableClass, Long num) {
        AssertFactory.notNull((Object)num, (String)"'num' must not be null ");
        SqlSourceClass sqlSourceClass = SqlSourceClass.getInstance(tableClass);
        LazyTableEndpoint lazyTableEndpoint = sqlSourceClass.getLazyTableEndpoint();
        if (this.operationConfig.getIgnoredDatabase().contains(lazyTableEndpoint.getSchema())) {
            log.warn("\u53d7\u4fdd\u62a4\u7684\u6570\u636e\u5e93:{}\u4e0d\u4f1a\u81ea\u52a8\u586b\u5145,\u66f4\u591a\u914d\u7f6e\u53c2\u8003\u914d\u7f6e\u6587\u4ef6\u6dfb\u52a0 spring.lazy.ignored-database:{} ", (Object)lazyTableEndpoint.getSchema(), (Object)this.operationConfig.getIgnoredDatabase());
            return;
        }
        if (num > this.operationConfig.getFillMaximum()) {
            long time = num / this.operationConfig.getFillMaximum();
            long remainingSize = num % this.operationConfig.getFillMaximum();
            int i = 0;
            while ((long)i < time) {
                this.threadPoolExecutor.submit(() -> {
                    ArrayList<Object> tList = new ArrayList<Object>();
                    int j = 0;
                    while ((long)j < this.operationConfig.getFillMaximum()) {
                        tList.add(DataTransformUntil.simulationBean((Class)tableClass));
                        ++j;
                    }
                    this.lazyLambdaStream.insert(tList);
                });
                ++i;
            }
            this.threadPoolExecutor.submit(() -> {
                ArrayList<Object> tList = new ArrayList<Object>();
                int i = 0;
                while ((long)i < remainingSize) {
                    tList.add(DataTransformUntil.simulationBean((Class)tableClass));
                    ++i;
                }
                this.lazyLambdaStream.insert(tList);
            });
        } else {
            ArrayList<Object> tList = new ArrayList<Object>();
            int i = 0;
            while ((long)i < num) {
                tList.add(DataTransformUntil.simulationBean(tableClass));
                ++i;
            }
            this.lazyLambdaStream.insert(tList);
        }
    }

    @Override
    public void stuffedJava(String schema, String tableName) {
        Class tableInfoClass = SourceFactory.findTableInfoClass();
        LazyTableInfo lazyTableInfo = (LazyTableInfo)this.lazyLambdaStream.selectOne((BasicComparison)LazyWrappers.lambdaWrapper().eqIgnoreEmpty(MySQLLazyTableInfo::getTableSchema, (Object)schema).eqIgnoreEmpty(MySQLLazyTableInfo::getTableName, (Object)tableName));
        List lazyColumnIndexList = this.lazyLambdaStream.selectList((BasicComparison)LazyWrappers.lambdaWrapper().eq(MySQLLazyColumnIndex::getTableSchema, (Object)schema).eq(MySQLLazyColumnIndex::getTableName, (Object)tableName));
        Map<String, List<LazyColumnIndex>> columnIndexMap = lazyColumnIndexList.stream().collect(Collectors.groupingBy(LazyColumnIndex::getColumnName));
        List fieldLazyTableFieldEndpointList = this.lazyLambdaStream.selectList((BasicComparison)LazyWrappers.lambdaWrapper().eqIgnoreEmpty(MySQLLazyColumn::getTableSchema, (Object)schema).eqIgnoreEmpty(MySQLLazyColumn::getTableName, (Object)tableName)).stream().map(lazyColumn -> {
            LazyTableFieldEndpoint fieldEndpoint = SourceFactory.getDefaultLazyTableFieldEndpointInstance();
            String columnName = lazyColumn.getColumnName();
            fieldEndpoint.setColumnName(columnName);
            fieldEndpoint.setName(CamelAndUnderLineConverter.lineToHumpField((String)columnName));
            fieldEndpoint.setComment(lazyColumn.getColumnComment());
            fieldEndpoint.setColumnType(lazyColumn.getColumnType());
            fieldEndpoint.setDataType(lazyColumn.getDataType());
            fieldEndpoint.setExtra(lazyColumn.getExtra());
            fieldEndpoint.setDefaultValue(lazyColumn.getColumnDefault());
            fieldEndpoint.setNotNull(!"yes".equalsIgnoreCase(lazyColumn.getIsNullable()));
            fieldEndpoint.setScale(lazyColumn.getNumericScale());
            if (columnIndexMap.containsKey(lazyColumn.getColumnName())) {
                List lazyColumnIndexs = (List)columnIndexMap.get(lazyColumn.getColumnName());
                LazyTableIndexEndpoint[] indexEndpoints = lazyColumnIndexs.stream().filter(lazyColumnIndex -> !"PRIMARY".equals(lazyColumnIndex.getIndexName())).map(lazyColumnIndex -> {
                    AbstractLazyTableIndexEndpoint instance = AbstractLazyTableIndexEndpoint.getInstance();
                    instance.setIndexName(lazyColumnIndex.getIndexName());
                    instance.setFieldIndexType(lazyColumnIndex.isNonUnique() ? LayerField.LayerFieldType.NORMAL : LayerField.LayerFieldType.UNIQUE);
                    return instance;
                }).collect(Collectors.toList()).toArray(new LazyTableIndexEndpoint[0]);
                fieldEndpoint.setLazyTableIndexEndpoints(indexEndpoints);
                fieldEndpoint.setKey(lazyColumnIndexs.stream().anyMatch(lazyColumnIndex -> "PRIMARY".equals(lazyColumnIndex.getIndexName())));
            }
            return fieldEndpoint;
        }).sorted((fieldLazyTableFieldEndpoint1, fieldLazyTableFieldEndpoint2) -> Collator.getInstance(Locale.CHINA).compare(fieldLazyTableFieldEndpoint1.getColumnName(), fieldLazyTableFieldEndpoint2.getColumnName())).collect(Collectors.toList());
        ReverseClassLazyTableEndpoint reverseClassLazyTableEndpoint = new ReverseClassLazyTableEndpoint();
        reverseClassLazyTableEndpoint.setSchema(schema);
        reverseClassLazyTableEndpoint.setTableName(tableName);
        reverseClassLazyTableEndpoint.setClassName(CamelAndUnderLineConverter.lineToHumpClass((String)tableName));
        reverseClassLazyTableEndpoint.setInLazyTableFieldEndpoints(fieldLazyTableFieldEndpointList);
        reverseClassLazyTableEndpoint.setOutLazyTableFieldEndpoints(fieldLazyTableFieldEndpointList);
        reverseClassLazyTableEndpoint.setModelLazyTableFieldEndpoints(fieldLazyTableFieldEndpointList);
        reverseClassLazyTableEndpoint.setComment(lazyTableInfo.getTableComment());
        reverseClassLazyTableEndpoint.setPackageName(this.operationConfig.getReverseEngineering().getPackageName() + "." + "domain");
        String entitySuffix = this.operationConfig.getReverseEngineering().getEntitySuffix();
        if (!ObjectUtils.isEmpty((Object)entitySuffix)) {
            String className = reverseClassLazyTableEndpoint.getClassName();
            reverseClassLazyTableEndpoint.setClassName(className + entitySuffix);
        }
        ReverseClassFactory.createJava((ReverseClassLazyTableEndpoint)reverseClassLazyTableEndpoint, (ReverseEngineering)this.operationConfig.getReverseEngineering());
    }
}

