/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.sql.expand.database.persistence.translation.api;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.wu.framework.bean.factory.BeanContext;
import org.wu.framework.core.CamelAndUnderLineConverter;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.persistence.util.LazySQLUtil;
import org.wu.framework.lazy.orm.core.source.SqlSourceClass;
import org.wu.framework.lazy.orm.core.source.adapter.SourceFactory;
import org.wu.framework.lazy.orm.database.lambda.stream.lambda.LazyLambdaStream;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.translation.api.LazyTranslationAPI;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.translation.endpoint.LazyTranslationTableEndpoint;
import org.wu.framework.translation.data.convert.LazyDataFactory;

public class LazyTableTranslationOneAPI
implements LazyTranslationAPI {
    @Override
    public ConcurrentMap<String, Object> translation(LazyTranslationTableEndpoint lazyTranslationTableEndpoint) {
        LazyLambdaStream lazyLambdaStream = (LazyLambdaStream)BeanContext.getBean(LazyLambdaStream.class);
        LazyTranslationTableEndpoint.Type type = lazyTranslationTableEndpoint.getType();
        String translationTargetTableName = lazyTranslationTableEndpoint.getTranslationTargetTableName();
        Class<?> translationTargetTableClass = lazyTranslationTableEndpoint.getTranslationTargetTableClass();
        if (ObjectUtils.isEmpty((Object)translationTargetTableName) && translationTargetTableClass != null) {
            SqlSourceClass sqlSourceClass = SqlSourceClass.getInstance(translationTargetTableClass);
            translationTargetTableName = sqlSourceClass.getLazyTableEndpoint().getTableName();
        }
        String[] columnList = lazyTranslationTableEndpoint.getColumnList();
        String translationSourceName = lazyTranslationTableEndpoint.getTranslationSourceName();
        String translationTargetName = lazyTranslationTableEndpoint.getTranslationTargetName();
        String translationTargetSqlName = CamelAndUnderLineConverter.humpToLine2((String)translationTargetName);
        Set<Object> sourceValues = lazyTranslationTableEndpoint.getSourceValues();
        Class<?> translationTargetType = lazyTranslationTableEndpoint.getTranslationTargetType();
        String sql = "";
        List columnSqlList = Arrays.stream(columnList).map(CamelAndUnderLineConverter::humpToLine2).collect(Collectors.toList());
        if (LazyTranslationTableEndpoint.Type.ALL.equals((Object)type)) {
            if (ObjectUtils.isEmpty(columnSqlList)) {
                columnSqlList.add("*");
            } else {
                String oldFirst = (String)columnSqlList.get(0);
                String newFirst = "*";
                columnSqlList.set(0, "*");
                columnSqlList.add(SourceFactory.cleanSpecialColumn((String)oldFirst));
            }
        } else {
            columnSqlList.add(SourceFactory.cleanSpecialColumn((String)translationTargetSqlName));
        }
        sql = "select " + String.join((CharSequence)",", columnSqlList) + " from " + translationTargetTableName + " where " + translationTargetSqlName + " in ({0})";
        List mapTranslationValueList = lazyLambdaStream.executeSQL(sql, Map.class, new Object[]{sourceValues.stream().filter(Objects::nonNull).map(o -> {
            Object columnData = LazySQLUtil.valueToSqlValue((Object)o);
            return columnData.toString();
        }).collect(Collectors.joining(","))});
        return mapTranslationValueList.stream().collect(Collectors.toConcurrentMap(map -> map.get(translationTargetSqlName).toString(), map -> {
            map.remove(translationTargetSqlName);
            if (map.keySet().size() == 1) {
                return map.values().stream().findFirst().get();
            }
            return LazyDataFactory.handler((Object)map, (Class)translationTargetType);
        }, (A, B) -> A));
    }
}

