/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.sql.expand.database.persistence.proxy;

import java.sql.Connection;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wu.framework.lazy.database.datasource.proxy.connection.LazyProxyConnection;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.LazyOperationMethod;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.proxy.AbstractLazyOperationProxyRetryInvocationHandler;

public abstract class AbstractLazyOperationProxyInvocationHandler
extends AbstractLazyOperationProxyRetryInvocationHandler {
    Logger log = LoggerFactory.getLogger(AbstractLazyOperationProxyInvocationHandler.class);

    abstract LazyProxyConnection determineConnection() throws SQLException;

    public Object doInvoke(LazyOperationMethod lazyOperationMethod, Object[] args) throws Exception {
        LazyProxyConnection connection = null;
        boolean isConnectionTransactional = false;
        boolean autoCommit = true;
        try {
            connection = this.determineConnection();
            if (connection.isClosed()) {
                this.log.error("this.connection  \u5173\u95ed\u4e86");
            }
            this.switchSchema((Connection)connection);
            isConnectionTransactional = connection.isConnectionTransactional();
            autoCommit = connection.getAutoCommit();
            Object execute = lazyOperationMethod.execute((Connection)connection, args);
            if (isConnectionTransactional && autoCommit) {
                this.log.debug("Committing JDBC Connection [" + connection + "]");
                connection.commit();
            }
            Object object = execute;
            return object;
        }
        catch (Exception exception) {
            if (connection != null && isConnectionTransactional && autoCommit) {
                this.log.debug("Rolling back JDBC Connection [" + connection + "]");
                connection.rollback();
            }
            exception.printStackTrace();
            throw exception;
        }
        finally {
            if (connection != null && autoCommit) {
                connection.connectionClose();
            }
        }
    }
}

