/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.interceptor.isDeleted;

import java.util.List;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.database.lambda.domain.PersistenceRepository;
import org.wu.framework.lazy.orm.database.lambda.stream.LambdaTableType;
import org.wu.framework.lazy.orm.database.lambda.stream.condition.part.Condition;
import org.wu.framework.lazy.orm.database.lambda.stream.condition.part.SqlPart;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.interceptor.AbstractSqlInterceptor;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.interceptor.isDeleted.LazyIsDeletedLineHandler;

public class IsDeletedSqlInterceptor
extends AbstractSqlInterceptor {
    private final LazyIsDeletedLineHandler lazyIsDeletedLineHandler;

    public IsDeletedSqlInterceptor(LazyIsDeletedLineHandler lazyIsDeletedLineHandler) {
        this.lazyIsDeletedLineHandler = lazyIsDeletedLineHandler;
    }

    @Override
    protected void beforeInsertInterceptor(PersistenceRepository persistenceRepository) {
    }

    @Override
    protected void beforeDeleteInterceptor(PersistenceRepository persistenceRepository) {
        this.intercept(persistenceRepository);
    }

    @Override
    protected void beforeUpdateInterceptor(PersistenceRepository persistenceRepository) {
        this.intercept(persistenceRepository);
    }

    private void intercept(PersistenceRepository persistenceRepository) {
        List<String> tableList = this.tableInterceptor(persistenceRepository);
        for (String table : tableList) {
            boolean ignoreTable = this.lazyIsDeletedLineHandler.ignoreTable(table);
            if (!ignoreTable) continue;
            return;
        }
        SqlPart sqlPart = persistenceRepository.getSqlPart();
        List<Condition> conditions = this.tableConditionInterceptor(persistenceRepository);
        String isDeletedColumn = this.lazyIsDeletedLineHandler.getIsDeletedColumn();
        Boolean isDeleted = this.lazyIsDeletedLineHandler.getIsDeleted();
        for (Condition condition : conditions) {
            Object rowName = condition.getRowName();
            if (!rowName.toString().contains(isDeletedColumn)) continue;
            isDeletedColumn = rowName.toString();
            break;
        }
        sqlPart.put((Object)isDeletedColumn, "=", (Object)isDeleted);
        persistenceRepository = sqlPart.persistenceRepository();
        String newSql = persistenceRepository.getBeforeQueryString();
        persistenceRepository.setQueryString(newSql);
    }

    @Override
    protected void beforeSelectInterceptor(PersistenceRepository persistenceRepository) {
        this.intercept(persistenceRepository);
    }

    @Override
    public boolean support(PersistenceRepository persistenceRepository) {
        if (ObjectUtils.isEmpty((Object)persistenceRepository)) {
            return false;
        }
        LambdaTableType executionType = persistenceRepository.getExecutionType();
        return executionType.equals((Object)LambdaTableType.INSERT) || executionType.equals((Object)LambdaTableType.UPSERT) || executionType.equals((Object)LambdaTableType.DELETE) || executionType.equals((Object)LambdaTableType.UPDATE) || executionType.equals((Object)LambdaTableType.SELECT) || executionType.equals((Object)LambdaTableType.BATCH);
    }

    public static final class DefaultLazyIsDeletedLineHandler
    implements LazyIsDeletedLineHandler {
        @Override
        public Boolean getIsDeleted() {
            return false;
        }
    }
}

