/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.dql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableEndpoint;
import org.wu.framework.lazy.orm.core.source.SqlSourceClass;
import org.wu.framework.lazy.orm.database.lambda.domain.LazyPage;
import org.wu.framework.lazy.orm.database.lambda.domain.PersistenceRepository;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.LazyOperationParameter;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.dql.AbstractLazyDQLOperationMethod;

public class LazyOperationMethodPage
extends AbstractLazyDQLOperationMethod {
    public static final String COUNT_SQL = "select count(1)  from ( {0} ) as derived_table ";
    public static final String LIMIT_SQL = "select * from ( {0} ) derived_table limit {1},{2} ";
    private String countSql;
    private String limitSql;
    private LazyPage lazyPage;

    public LazyOperationMethodPage(LazyOperationParameter lazyOperationParameter) {
        super(lazyOperationParameter);
    }

    @Override
    public PersistenceRepository doAnalyzePersistenceRepository(Object[] sourceParams) throws Exception {
        String queryString = "";
        Object[] p = sourceParams;
        this.lazyPage = (LazyPage)p[0];
        Class clazz = (Class)p[1];
        String sqlFormat = (String)p[2];
        Object[] params = (Object[])p[3];
        if (null == sqlFormat) {
            SqlSourceClass sqlSourceClass = SqlSourceClass.getInstance((Class)clazz);
            LazyTableEndpoint lazyTableEndpoint = sqlSourceClass.getLazyTableEndpoint();
            sqlFormat = String.format("select * from %s ", lazyTableEndpoint.getFullTableName());
        }
        String listSql = this.loadSqlParameters(sqlFormat, params);
        this.countSql = this.loadSqlParameters(COUNT_SQL, listSql);
        this.limitSql = this.loadSqlParameters(LIMIT_SQL, listSql, (this.lazyPage.getCurrent() - 1) * this.lazyPage.getSize(), this.lazyPage.getSize());
        queryString = this.countSql + ";" + this.limitSql;
        List ascs = this.lazyPage.getAscs();
        List descs = this.lazyPage.getDescs();
        if (!ObjectUtils.isEmpty((Object)ascs) || !ObjectUtils.isEmpty((Object)descs)) {
            queryString = queryString + " " + " order by ";
        }
        if (!ObjectUtils.isEmpty((Object)ascs)) {
            queryString = queryString + String.join((CharSequence)",", ascs) + " " + "ASC";
        }
        if (!ObjectUtils.isEmpty((Object)descs)) {
            queryString = !ObjectUtils.isEmpty((Object)ascs) ? "," + queryString + String.join((CharSequence)",", ascs) + " " + "ASC" : queryString + String.join((CharSequence)",", ascs) + " " + "ASC";
        }
        PersistenceRepository persistenceRepository = this.createPersistenceRepository();
        persistenceRepository.setQueryString(queryString);
        persistenceRepository.setResultClass(clazz);
        return persistenceRepository;
    }

    @Override
    public Object doExecute(Connection connection, Object[] sourceParams) throws SQLException {
        Statement statement = null;
        PersistenceRepository persistenceRepository = null;
        try {
            persistenceRepository = this.analyzePersistenceRepository(sourceParams);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String queryString = persistenceRepository.getQueryString();
        try {
            this.count(connection);
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(this.limitSql);
            List result = this.resultSetConverter(resultSet, persistenceRepository.getResultType());
            this.lazyPage.setRecords(result);
            LazyPage lazyPage = this.lazyPage;
            return lazyPage;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException | SQLException exception) {
            throw new SQLException(queryString, exception);
        }
        finally {
            if (null != statement) {
                statement.close();
            }
        }
    }

    private void count(Connection connection) throws SQLException, NoSuchFieldException, InstantiationException, IllegalAccessException {
        PreparedStatement countPreparedStatement = connection.prepareStatement(this.countSql);
        ResultSet resultSet = countPreparedStatement.executeQuery();
        List<Long> objects = this.resultSetConverter(resultSet, Long.class);
        long total = objects.get(0);
        long pages = (total + (long)this.lazyPage.getSize() + 1L) / (long)this.lazyPage.getSize();
        this.lazyPage.setTotal(total);
        this.lazyPage.setPages(pages);
        countPreparedStatement.close();
    }
}

