/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.dql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.wu.framework.lazy.orm.database.lambda.domain.LazyPage;
import org.wu.framework.lazy.orm.database.lambda.domain.PersistenceRepository;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.LazyOperationParameter;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.dql.AbstractLazyDQLOperationMethod;

public class LazyOperationMethodExecutePage
extends AbstractLazyDQLOperationMethod {
    public static final String COUNT_SQL = "select count(1)  from ( {0} ) as derived_table ";
    public static final String LIMIT_SQL = "select * from ( {0} ) derived_table limit {1},{2} ";

    public LazyOperationMethodExecutePage(LazyOperationParameter lazyOperationParameter) {
        super(lazyOperationParameter);
    }

    @Override
    public PersistenceRepository doAnalyzePersistenceRepository(Object[] sourceParams) throws Exception {
        return (PersistenceRepository)sourceParams[0];
    }

    @Override
    public Object doExecute(Connection connection, Object[] sourceParams) throws SQLException, NoSuchFieldException, InstantiationException, IllegalAccessException {
        LazyPage lazyPage = (LazyPage)sourceParams[1];
        Statement statement = null;
        PersistenceRepository persistenceRepository = null;
        try {
            persistenceRepository = this.analyzePersistenceRepository(sourceParams);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String listSql = persistenceRepository.getQueryString();
        String countSql = this.loadSqlParameters(COUNT_SQL, listSql);
        String limitSql = this.loadSqlParameters(LIMIT_SQL, listSql, (lazyPage.getCurrent() - 1) * lazyPage.getSize(), lazyPage.getSize());
        try {
            this.count(connection, countSql, lazyPage);
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(limitSql);
            List result = this.resultSetConverter(resultSet, persistenceRepository.getResultType());
            lazyPage.setRecords(result);
            LazyPage lazyPage2 = lazyPage;
            return lazyPage2;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchFieldException | SQLException exception) {
            throw new SQLException(listSql, exception);
        }
        finally {
            if (null != statement) {
                statement.close();
            }
        }
    }

    private void count(Connection connection, String countSql, LazyPage<?> lazyPage) throws SQLException, NoSuchFieldException, InstantiationException, IllegalAccessException {
        PreparedStatement countPreparedStatement = connection.prepareStatement(countSql);
        ResultSet resultSet = countPreparedStatement.executeQuery();
        List<Long> objects = this.resultSetConverter(resultSet, Long.class);
        long total = objects.get(0);
        long pages = (total + (long)lazyPage.getSize() + 1L) / (long)lazyPage.getSize();
        lazyPage.setTotal(total);
        lazyPage.setPages(pages);
        countPreparedStatement.close();
    }
}

