/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.dml;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.wu.framework.core.stereotype.LayerField;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.factory.LazyTableStructureConverterFactory;
import org.wu.framework.lazy.orm.core.factory.LazyTableUpdateConverterFactory;
import org.wu.framework.lazy.orm.core.factory.LazyTableUpsertConverterFactory;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyDatabaseJsonMessage;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableFieldEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableStructure;
import org.wu.framework.lazy.orm.core.stereotype.LazyTableFieldId;
import org.wu.framework.lazy.orm.database.lambda.domain.Persistence;
import org.wu.framework.lazy.orm.database.lambda.domain.PersistenceRepository;
import org.wu.framework.lazy.orm.database.lambda.stream.LambdaTableType;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.AbstractLazyOperationMethod;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.LazyOperationParameter;

public class LazyOperationMethodSaveOrUpdate
extends AbstractLazyOperationMethod {
    public LazyOperationMethodSaveOrUpdate(LazyOperationParameter lazyOperationParameter) {
        super(lazyOperationParameter);
    }

    @Override
    public PersistenceRepository doAnalyzePersistenceRepository(Object[] sourceParams) throws Exception {
        LazyTableStructure lazyTableStructure = LazyTableStructureConverterFactory.dataStructure((Object)sourceParams);
        LazyTableEndpoint endpoint = lazyTableStructure.schema();
        List payload = lazyTableStructure.payload();
        String tableName = endpoint.getTableName();
        String schema = endpoint.getSchema();
        StringBuffer stringBuffer = new StringBuffer(Persistence.ExecutionEnum.INSERT.getExecution());
        if (ObjectUtils.isEmpty((Object)schema)) {
            stringBuffer.append(tableName);
        } else {
            stringBuffer.append(schema).append(".").append(tableName);
        }
        stringBuffer.append("(");
        stringBuffer.append(endpoint.getLazyTableFieldEndpointList().stream().filter(fieldLazyTableFieldEndpoint -> !LazyTableFieldId.IdType.AUTOMATIC_ID.equals((Object)fieldLazyTableFieldEndpoint.getIdType())).map(fieldLazyTableFieldEndpoint -> {
            String columnName = fieldLazyTableFieldEndpoint.getColumnName();
            if (LazyDatabaseJsonMessage.specialFields.contains(columnName.toUpperCase(Locale.ROOT))) {
                return "`" + columnName + "`";
            }
            return columnName;
        }).collect(Collectors.joining(",")));
        stringBuffer.append(")");
        stringBuffer.append("VALUES");
        stringBuffer.append(payload.stream().map(item -> "(" + item.stream().map(o -> null == o.getFieldValue() ? null : "'" + o.getFieldValue() + "'").collect(Collectors.joining(",")) + ")").collect(Collectors.joining(",")));
        String sql = stringBuffer.toString();
        PersistenceRepository persistenceRepository = this.createPersistenceRepository();
        persistenceRepository.setExecutionType(LambdaTableType.INSERT);
        persistenceRepository.setQueryString(sql);
        return persistenceRepository;
    }

    @Override
    public Object doExecute(Connection connection, Object[] sourceParams) throws Exception {
        Object param = sourceParams[0];
        if (param instanceof Object[]) {
            Object[] insertList;
            for (Object saveOrUpdate : insertList = (Object[])param) {
                this.accurateDoExecution(connection, saveOrUpdate);
            }
        } else {
            this.accurateDoExecution(connection, param);
        }
        return sourceParams.length;
    }

    /*
     * Loose catch block
     */
    @Override
    public Object accurateDoExecution(Connection connection, Object saveOrUpdate) throws Exception {
        block32: {
            List lazyTableFieldEndpoints;
            LazyTableStructure lazyTableStructure;
            block31: {
                lazyTableStructure = LazyTableStructureConverterFactory.dataStructure((Object)saveOrUpdate);
                lazyTableFieldEndpoints = (List)lazyTableStructure.payload().get(0);
                boolean anyMatchKey = lazyTableFieldEndpoints.stream().anyMatch(lazyTableFieldEndpoint -> lazyTableFieldEndpoint.isKey() && null != lazyTableFieldEndpoint.getFieldValue());
                if (anyMatchKey) {
                    LazyTableFieldEndpoint fieldEndpoint = lazyTableStructure.schema().getLazyTableFieldEndpointList().stream().filter(LazyTableFieldEndpoint::isKey).findFirst().get();
                    String pk = fieldEndpoint.getColumnName();
                    Object pkValue = fieldEndpoint.getFieldValue();
                    String selectPKSql = String.format("select count(1) from %s where %s = %s ", lazyTableStructure.schema().getTableName(), pk, pkValue);
                    try (PreparedStatement selectPreparedStatement = connection.prepareStatement(selectPKSql);){
                        ResultSet resultSet = selectPreparedStatement.executeQuery();
                        List<Integer> countPk = this.resultSetConverter(resultSet, Integer.class);
                        if (countPk.get(0) == 1) {
                            String updateSql = LazyTableUpdateConverterFactory.updateByPK((Object)saveOrUpdate);
                            try (PreparedStatement preparedStatement2 = connection.prepareStatement(updateSql);){
                                Boolean bl = preparedStatement2.execute();
                                return bl;
                            }
                        }
                        break block31;
                        {
                            catch (Exception e) {
                                throw new SQLException(selectPKSql, e);
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                }
            }
            Collection whereLazyTableFieldEndpointList = ((List)lazyTableStructure.payload().get(0)).stream().filter(lazyTableFieldEndpoint -> Arrays.stream(lazyTableFieldEndpoint.getLazyTableIndexEndpoints()).anyMatch(lazyTableIndexEndpoint -> LayerField.LayerFieldType.UNIQUE.equals((Object)lazyTableIndexEndpoint.getFieldIndexType())) && null != lazyTableFieldEndpoint.getFieldValue()).collect(Collectors.toList());
            boolean anyMatchUniqueKey = lazyTableFieldEndpoints.stream().anyMatch(lazyTableFieldEndpoint -> Arrays.stream(lazyTableFieldEndpoint.getLazyTableIndexEndpoints()).anyMatch(lazyTableIndexEndpoint -> LayerField.LayerFieldType.UNIQUE.equals((Object)lazyTableIndexEndpoint.getFieldIndexType())) && null != lazyTableFieldEndpoint.getFieldValue());
            if (anyMatchUniqueKey) {
                String selectCountUniqueSql = String.format("select count(1) from %s where %s ", lazyTableStructure.schema().getTableName(), whereLazyTableFieldEndpointList.stream().map(lazyTableFieldEndpoint -> " " + lazyTableFieldEndpoint.getColumnName() + "=" + "'" + lazyTableFieldEndpoint.getFieldValue() + "'").collect(Collectors.joining(" and")));
                try (PreparedStatement selectCountUniquePreparedStatement = connection.prepareStatement(selectCountUniqueSql);){
                    ResultSet resultSet = selectCountUniquePreparedStatement.executeQuery();
                    List<Long> countUnique = this.resultSetConverter(resultSet, Long.class);
                    if (countUnique.get(0) > 0L) {
                        String updateSql = LazyTableUpdateConverterFactory.updateUniqueKey((Object)saveOrUpdate);
                        try (PreparedStatement preparedStatement = connection.prepareStatement(updateSql);){
                            Boolean preparedStatement2 = preparedStatement.execute();
                            return preparedStatement2;
                        }
                    }
                    break block32;
                    {
                        catch (Exception e) {
                            throw new SQLException(selectCountUniqueSql, e);
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
        }
        String insertSql = LazyTableUpsertConverterFactory.insert((Object)saveOrUpdate);
        try (PreparedStatement preparedStatement = connection.prepareStatement(insertSql);){
            boolean execute = preparedStatement.execute();
            Boolean bl = execute;
            return bl;
        }
    }
}

