/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.ddl;

import java.sql.Connection;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wu.framework.core.io.ScriptResource;
import org.wu.framework.lazy.orm.database.lambda.domain.PersistenceRepository;
import org.wu.framework.lazy.orm.database.lambda.stream.LambdaTableType;
import org.wu.framework.lazy.orm.database.lambda.stream.script.ScriptResourceDatabasePopulator;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.LazyOperationParameter;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.ddl.AbstractLazyDDLOperationMethod;

public class LazyOperationMethodScriptRunner
extends AbstractLazyDDLOperationMethod {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LazyOperationMethodScriptRunner.class);

    public LazyOperationMethodScriptRunner(LazyOperationParameter lazyOperationParameter) {
        super(lazyOperationParameter);
    }

    @Override
    public PersistenceRepository doAnalyzePersistenceRepository(Object[] sourceParams) throws Exception {
        PersistenceRepository persistenceRepository = this.createPersistenceRepository();
        persistenceRepository.setExecutionType(LambdaTableType.SCRIPT_RUNNER);
        ArrayList<String> pathList = new ArrayList<String>();
        for (Object sourceParam : sourceParams) {
            if (sourceParam instanceof ScriptResource[]) {
                ScriptResource[] resources;
                for (ScriptResource resource : resources = (ScriptResource[])sourceParam) {
                    String path = resource.getPath();
                    pathList.add(path);
                }
                continue;
            }
            String path = ((ScriptResource)sourceParam).getPath();
            pathList.add(path);
        }
        persistenceRepository.setQueryString("\u6267\u884csql\u6587\u4ef6\uff1a" + String.join((CharSequence)"\u3001", pathList));
        return persistenceRepository;
    }

    @Override
    public Object doExecute(Connection connection, Object[] sourceParams) throws Exception {
        log.info("\u6570\u636e\u521d\u59cb\u5316\u5f00\u59cb: " + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        ScriptResourceDatabasePopulator scriptResourceDatabasePopulator = new ScriptResourceDatabasePopulator();
        Object sourceParam = sourceParams[0];
        if (sourceParam instanceof ScriptResource[]) {
            ScriptResource[] resources;
            for (ScriptResource resource : resources = (ScriptResource[])sourceParam) {
                scriptResourceDatabasePopulator.addScripts(resource);
            }
        } else {
            ScriptResource scriptResource = (ScriptResource)sourceParam;
            scriptResourceDatabasePopulator.addScripts(scriptResource);
        }
        scriptResourceDatabasePopulator.populate(connection);
        log.info("\u6570\u636e\u521d\u59cb\u5316\u7ed3\u675f: " + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        return true;
    }
}

