/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.framework.wu.framework.queue.Message;
import org.framework.wu.framework.queue.MessageQueue;
import org.framework.wu.framework.queue.MessageQueueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wu.framework.core.CamelAndUnderLineConverter;
import org.wu.framework.core.ReflexUtils;
import org.wu.framework.core.stereotype.MethodParamFunction;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.config.LazyOperationAttribute;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableFieldEndpoint;
import org.wu.framework.lazy.orm.core.persistence.map.EasyHashMap;
import org.wu.framework.lazy.orm.core.persistence.map.StringRowMap;
import org.wu.framework.lazy.orm.core.persistence.util.SqlMessageFormatUtil;
import org.wu.framework.lazy.orm.core.source.SqlSourceClass;
import org.wu.framework.lazy.orm.database.lambda.domain.PersistenceRepository;
import org.wu.framework.lazy.orm.database.lambda.domain.PersistenceRepositoryFactory;
import org.wu.framework.lazy.orm.database.lambda.stream.LambdaTableType;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.LazyOperationMethod;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.method.LazyOperationParameter;
import org.wu.framework.translation.data.convert.LazyDataFactory;
import org.wu.framework.translation.data.schema.SchemaMap;

public abstract class AbstractLazyOperationMethod
implements LazyOperationMethod {
    private final LazyOperationParameter lazyOperationParameter;
    Logger log = LoggerFactory.getLogger(AbstractLazyOperationMethod.class);

    protected AbstractLazyOperationMethod(LazyOperationParameter lazyOperationParameter) {
        this.lazyOperationParameter = lazyOperationParameter;
    }

    @Deprecated
    public static boolean isWrapClass(Class<?> clazz) {
        try {
            if (String.class.isAssignableFrom(clazz)) {
                return true;
            }
            if (Byte[].class.isAssignableFrom(clazz)) {
                return true;
            }
            if (Byte.class.isAssignableFrom(clazz)) {
                return true;
            }
            if (byte[].class.isAssignableFrom(clazz)) {
                return true;
            }
            if (Byte.TYPE.isAssignableFrom(clazz)) {
                return true;
            }
            return ((Class)clazz.getField("TYPE").get(null)).isPrimitive();
        }
        catch (Exception e) {
            return false;
        }
    }

    protected LazyOperationParameter lazyOperationParameter() {
        return this.lazyOperationParameter;
    }

    protected PersistenceRepository createPersistenceRepository() {
        if (ObjectUtils.isEmpty((Object)this.lazyOperationParameter())) {
            return PersistenceRepositoryFactory.create();
        }
        return PersistenceRepositoryFactory.create((LazyOperationAttribute)this.lazyOperationParameter().getLazyOperationAttribute());
    }

    @Override
    public PersistenceRepository analyzePersistenceRepository(Object[] sourceParams) {
        PersistenceRepository persistenceRepository;
        try {
            persistenceRepository = this.doAnalyzePersistenceRepository(sourceParams);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.lazyOperationParameter().getSqlInterceptorAdapter().interceptor(persistenceRepository);
        return persistenceRepository;
    }

    public abstract PersistenceRepository doAnalyzePersistenceRepository(Object[] var1) throws Exception;

    @Override
    public Object execute(Connection connection, Object[] sourceParams) throws Exception {
        Object o = this.doExecute(connection, sourceParams);
        return o;
    }

    public Object doExecute(Connection connection, Object[] sourceParams) throws Exception {
        int n = 0;
        Object[] objectArray = sourceParams;
        int n2 = objectArray.length;
        if (n < n2) {
            Object param = objectArray[n];
            try (PreparedStatement preparedStatement = connection.prepareStatement(this.analyzePersistenceRepository(new Object[]{param}).getQueryString());){
                Boolean bl = preparedStatement.execute();
                return bl;
            }
        }
        return null;
    }

    public Object accurateDoExecution(Connection connection, Object param) throws Exception {
        return this.executionFunction(connection, (MethodParamFunction<PreparedStatement>)((MethodParamFunction)preparedStatement -> {
            preparedStatement.execute();
            return preparedStatement;
        }), param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executionFunction(Connection connection, MethodParamFunction<PreparedStatement> methodParamFunction, Object param) throws Exception {
        PersistenceRepository persistenceRepository = this.analyzePersistenceRepository(new Object[]{param});
        try (PreparedStatement preparedStatement = connection.prepareStatement(persistenceRepository.getQueryString());){
            Object object = methodParamFunction.defaultMethod((Object)preparedStatement);
            return object;
        }
    }

    public <E> List<E> resultSetConverter(ResultSet resultSet, String resultType) throws SQLException, NoSuchFieldException, InstantiationException, IllegalAccessException {
        Class<?> domainClass = null;
        try {
            domainClass = Class.forName(resultType);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return this.resultSetConverter(resultSet, domainClass);
    }

    public <E> List<E> resultSetConverter(ResultSet resultSet, Class<? extends E> domainClass) throws SQLException, InstantiationException, IllegalAccessException, NoSuchFieldException {
        ArrayList<Object> sqlResult = new ArrayList<Object>();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        if (Map.class.isAssignableFrom(domainClass)) {
            while (resultSet.next()) {
                EasyHashMap rowMap = new HashMap();
                if (EasyHashMap.class.isAssignableFrom(domainClass)) {
                    rowMap = new EasyHashMap();
                    String tableName = resultSetMetaData.getTableName(1);
                    rowMap.setUniqueLabel(CamelAndUnderLineConverter.capitalizeFirstLetter((String)tableName));
                } else if (SchemaMap.class.isAssignableFrom(domainClass)) {
                    rowMap = new SchemaMap();
                } else if (StringRowMap.class.isAssignableFrom(domainClass)) {
                    rowMap = new StringRowMap();
                }
                int columnCount = resultSetMetaData.getColumnCount();
                for (int i = 1; i <= columnCount; ++i) {
                    String columnName = resultSetMetaData.getColumnName(i);
                    String columnClassName = resultSetMetaData.getColumnClassName(i);
                    Object columnValue = resultSet.getObject(i);
                    String columnLabel = resultSetMetaData.getColumnLabel(i);
                    String string = columnName = ObjectUtils.isEmpty((Object)columnLabel) ? columnName : columnLabel;
                    if (EasyHashMap.class.isAssignableFrom(domainClass)) {
                        rowMap.put((Object)CamelAndUnderLineConverter.lineToHumpField((String)columnName), columnValue, columnClassName);
                        continue;
                    }
                    if (SchemaMap.class.isAssignableFrom(domainClass)) {
                        rowMap.put(CamelAndUnderLineConverter.lineToHumpField((String)columnName), columnValue);
                        continue;
                    }
                    rowMap.put(columnName, columnValue);
                }
                sqlResult.add(rowMap);
            }
        } else if (AbstractLazyOperationMethod.isWrapClass(domainClass)) {
            while (resultSet.next()) {
                Object rowData = resultSet.getObject(1);
                Object handler = LazyDataFactory.handler((Object)rowData, domainClass);
                sqlResult.add(handler);
            }
        } else {
            List convertedFieldList = SqlSourceClass.getInstance(domainClass).getLazyTableEndpoint().getLazyTableFieldEndpointList();
            Map<String, String> convertedFieldMap = convertedFieldList.stream().collect(Collectors.toMap(LazyTableFieldEndpoint::getName, LazyTableFieldEndpoint::getName));
            convertedFieldMap.putAll(convertedFieldList.stream().collect(Collectors.toMap(lazyTableFieldEndpoint -> CamelAndUnderLineConverter.humpToLine2((String)lazyTableFieldEndpoint.getName()), LazyTableFieldEndpoint::getName)));
            int columnCount = resultSetMetaData.getColumnCount();
            ConcurrentHashMap<Integer, Field> cacheField = new ConcurrentHashMap<Integer, Field>();
            for (int columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
                String columnName = resultSetMetaData.getColumnName(columnIndex).toLowerCase();
                columnName = CamelAndUnderLineConverter.lineToHumpField((String)columnName);
                String columnLabel = resultSetMetaData.getColumnLabel(columnIndex);
                String fieldName = convertedFieldMap.getOrDefault(columnLabel, convertedFieldMap.getOrDefault(columnName, null));
                if (ObjectUtils.isEmpty((Object)fieldName)) continue;
                Field field = domainClass.getDeclaredField(fieldName);
                field.setAccessible(true);
                cacheField.put(columnIndex, field);
            }
            while (resultSet.next()) {
                Object e = ReflexUtils.newInstance(domainClass);
                for (int columnIndex = 1; columnIndex <= columnCount; ++columnIndex) {
                    Field field = (Field)cacheField.get(columnIndex);
                    Object object = resultSet.getObject(columnIndex);
                    LazyDataFactory.handler((Object)e, (Field)field, (Object)object);
                }
                sqlResult.add(e);
            }
        }
        return sqlResult;
    }

    public String loadSqlParameters(String sqlFormat, Object ... params) {
        Object[] objects = Arrays.stream(params).map(o -> o).toArray(Object[]::new);
        PersistenceRepository persistenceRepository = PersistenceRepositoryFactory.create();
        String sql = SqlMessageFormatUtil.format((String)sqlFormat, (Object[])objects);
        persistenceRepository.setQueryString(sql);
        return persistenceRepository.getQueryString();
    }

    public MessageQueue getLazyOrmMessageQueue() {
        String eventQueueName = this.lazyOperationParameter.getLazyOperationAttribute().getEventQueueName();
        return MessageQueueFactory.getQueue((String)eventQueueName);
    }

    public void sendLazyOrmEvent(LambdaTableType lambdaTableType, Object body) {
        Message message = new Message(lambdaTableType.name(), body);
        this.getLazyOrmMessageQueue().send(message);
    }
}

