/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.sql.expand.database.persistence.cure.lazy;

import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyDatabaseJsonMessage;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableEndpoint;
import org.wu.framework.lazy.orm.core.source.SqlSourceClass;
import org.wu.framework.lazy.orm.core.source.adapter.SourceFactory;
import org.wu.framework.lazy.orm.database.lambda.LazyBaseDDLOperation;
import org.wu.framework.lazy.orm.database.lambda.LazyBaseDQLOperation;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.cure.AbstractCure;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.cure.Cure;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.cure.TableColumnCure;
import org.wu.framework.lazy.orm.database.sql.util.SqlUtils;

public class LazyTableColumnCure
extends AbstractCure
implements TableColumnCure,
Cure {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LazyTableColumnCure.class);
    private final LazyBaseDDLOperation lazyBaseDDLOperation;
    private final LazyBaseDQLOperation lazyBaseDQLOperation;

    public LazyTableColumnCure(LazyBaseDDLOperation lazyBaseDDLOperation, LazyBaseDQLOperation lazyBaseDQLOperation) {
        this.lazyBaseDDLOperation = lazyBaseDDLOperation;
        this.lazyBaseDQLOperation = lazyBaseDQLOperation;
    }

    @Override
    public boolean supportsSQLException(SQLException sqlException) {
        String sqlState = sqlException.getSQLState();
        return "42S22".equals(sqlState);
    }

    @Override
    public void cureByThrowable(int retryTime, Throwable throwable) throws Throwable {
        log.warn("\u901a\u8fc7\u5f02\u5e38\u81ea\u52a8\u6cbb\u6108\u8868\u5b57\u6bb5");
        String message = throwable.getMessage();
        List<String> tables = SqlUtils.tablesInSql(message);
        if (ObjectUtils.isEmpty(tables)) {
            return;
        }
        ConcurrentMap tableCache = SourceFactory.getClassTableCache();
        List<Class> cacheClazz = tableCache.values().stream().filter(lazyTableEndpoint -> {
            String tableName = lazyTableEndpoint.getTableName();
            if (!ObjectUtils.isEmpty((Object)lazyTableEndpoint.getSchema())) {
                tableName = lazyTableEndpoint.getSchema() + "." + lazyTableEndpoint.getTableName();
            }
            return tables.contains(tableName);
        }).map(LazyTableEndpoint::getClazz).collect(Collectors.toList());
        if (ObjectUtils.isEmpty(cacheClazz)) {
            log.info("\u6570\u636e\u5e93\u5b57\u6bb5\u6cbb\u6108\u5931\u8d25\u65e0\u6cd5\u89e3\u6790\u5230tables:[{}],\u5bf9\u5e94\u7684class:[{}]\u3002\u539f\u59cb\u5f02\u5e38\u4fe1\u606f\u4e3a:{}", new Object[]{tables, tableCache, message});
            return;
        }
        LazyDatabaseJsonMessage.localCacheEntityClass.removeAll(cacheClazz);
        this.lazyBaseDDLOperation.updateTable(cacheClazz.toArray(new Class[0]));
        log.debug("\u6267\u884c" + cacheClazz.stream().map(clazz -> {
            SqlSourceClass sqlSourceClass = SqlSourceClass.getInstance((Class)clazz);
            return sqlSourceClass.getLazyTableEndpoint();
        }).map(LazyTableEndpoint::getTableName).collect(Collectors.joining(",")) + "\u521b\u5efa\u6570\u636e\u5e93\u5b57\u6bb5", throwable);
        ConcurrentMap tableMapCache = SourceFactory.getMapTableCache();
        List<LazyTableEndpoint> cacheLazyTableEndpoint = tableMapCache.values().stream().filter(lazyTableEndpoint -> {
            String tableName = lazyTableEndpoint.getTableName();
            if (!ObjectUtils.isEmpty((Object)lazyTableEndpoint.getSchema())) {
                tableName = lazyTableEndpoint.getSchema() + "." + lazyTableEndpoint.getTableName();
            }
            return tables.contains(tableName);
        }).collect(Collectors.toList());
        if (ObjectUtils.isEmpty(cacheLazyTableEndpoint)) {
            log.info("\u6570\u636e\u5e93\u5b57\u6bb5\u6cbb\u6108\u5931\u8d25\u65e0\u6cd5\u89e3\u6790\u5230tables:[{}],\u5bf9\u5e94\u7684class:[{}]\u3002\u539f\u59cb\u5f02\u5e38\u4fe1\u606f\u4e3a:{}", new Object[]{tables, tableMapCache, message});
            return;
        }
        this.lazyBaseDDLOperation.updateTable(cacheLazyTableEndpoint.toArray(new LazyTableEndpoint[0]));
        log.debug("\u6267\u884c{}\u521b\u5efa\u6570\u636e\u5e93\u5b57\u6bb5", (Object)cacheLazyTableEndpoint.stream().map(LazyTableEndpoint::getTableName).collect(Collectors.joining(",")), (Object)throwable);
    }
}

