/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.sql.expand.database.persistence.cure.lazy;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyDatabaseJsonMessage;
import org.wu.framework.lazy.orm.database.lambda.LazyBaseDDLOperation;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.cure.AbstractCure;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.cure.Cure;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.cure.SchemaCure;
import org.wu.framework.lazy.orm.database.sql.util.SqlUtils;

public class LazySchemaCure
extends AbstractCure
implements SchemaCure,
Cure {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LazySchemaCure.class);
    private final LazyBaseDDLOperation lazyBaseDDLOperation;

    public LazySchemaCure(LazyBaseDDLOperation lazyBaseDDLOperation) {
        this.lazyBaseDDLOperation = lazyBaseDDLOperation;
    }

    @Override
    public boolean supportsSQLException(SQLException sqlSyntaxErrorException) {
        String sqlState = sqlSyntaxErrorException.getSQLState();
        int vendorCode = sqlSyntaxErrorException.getErrorCode();
        return "42000".equals(sqlState) && 1049 == vendorCode;
    }

    @Override
    public void cureByThrowable(int retryTime, Throwable throwable) throws Throwable {
        log.warn("\u901a\u8fc7\u5f02\u5e38\u81ea\u52a8\u6cbb\u6108schema");
        String message = throwable.getMessage();
        List<String> schemas = SqlUtils.schema(message);
        this.create(schemas);
        log.debug("\u6267\u884c\u521b\u5efa\u6570\u636e\u5e93:" + String.join((CharSequence)",", schemas), throwable);
    }

    public void create(List<String> schemas) {
        ArrayList<String> schemaCreates = new ArrayList<String>();
        for (String schema : schemas) {
            if (LazyDatabaseJsonMessage.specialSchema.contains(schema)) {
                log.warn("\u62d2\u7edd\u521b\u5efa\u6570\u636e:" + schema);
                break;
            }
            String format = "CREATE  DATABASE IF NOT EXISTS `%s` CHARACTER SET utf8mb4 ;";
            schemaCreates.add(String.format(format, schema));
        }
        this.lazyBaseDDLOperation.stringScriptRunner(schemaCreates.toArray(new String[0]));
        log.info("\u521d\u59cb\u5316\u521b\u5efa\u6570\u636e\u5e93:\u3010{}\u3011", schemas);
    }
}

