/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.sql.expand.database.persistence.cure;

import java.lang.reflect.Method;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wu.framework.core.proxy.ProxyRetryInvocationHandler;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.database.sql.expand.database.persistence.cure.Cure;

public class CureAdapter {
    private final Logger log = LoggerFactory.getLogger(CureAdapter.class);
    private final List<Cure> cureList;

    public CureAdapter(List<Cure> cureList) {
        this.cureList = cureList;
    }

    public Object cure(ProxyRetryInvocationHandler invocationHandler, Object proxy, Method method, Object[] args, int retryTime, Throwable throwable) throws Throwable {
        if (retryTime <= 0) {
            throw throwable;
        }
        if (ObjectUtils.isEmpty(this.cureList)) {
            this.log.warn("\u5f53\u524d\u7cfb\u7edf\u53ea\u662f\u6570\u636e\u5e93\u6cbb\u6108\uff0c\u4f46\u662f\u65e0\u6cd5\u627e\u5230\u6cbb\u6108\u7684\u5b9e\u73b0\u8bf7\u68c0\u67e5 Cure \u7684\u5b9e\u73b0\u7c7b\u662f\u5426\u6ce8\u5165");
        }
        for (Cure cure : this.cureList) {
            if (!cure.supports(throwable)) continue;
            try {
                cure.cure(retryTime - 1, throwable);
                return invocationHandler.retryInvoke(proxy, method, args, retryTime - 1, throwable, true);
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.log.error("\u6570\u636e\u5e93\u9002\u914d\u5668\u6267\u884c\u6cbb\u6108\u5931\u8d25", e);
            }
        }
        throw throwable;
    }

    public void cureOne(Throwable throwable) throws Throwable {
        for (Cure cure : this.cureList) {
            if (!cure.supports(throwable)) continue;
            try {
                cure.cure(0, throwable);
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.log.error("\u6570\u636e\u5e93\u6267\u884cone\u6cbb\u6108\u5931\u8d25", e);
            }
        }
        throw throwable;
    }
}

