/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.toolkit;

import java.util.ArrayDeque;
import java.util.Deque;

public final class LazyCureContextHolder {
    private static final ThreadLocal<Deque<Integer>> LOOKUP_KEY_HOLDER = ThreadLocal.withInitial(ArrayDeque::new);

    private LazyCureContextHolder() {
    }

    public static Integer peek() {
        return LOOKUP_KEY_HOLDER.get().peek();
    }

    public static void push(Integer cureTime) {
        LOOKUP_KEY_HOLDER.get().push(cureTime);
    }

    public static void poll() {
        Deque<Integer> deque = LOOKUP_KEY_HOLDER.get();
        deque.poll();
        if (deque.isEmpty()) {
            LOOKUP_KEY_HOLDER.remove();
        }
    }

    public static void clear() {
        LOOKUP_KEY_HOLDER.remove();
    }
}

