/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.lambda.stream.script;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wu.framework.core.exception.AssertFactory;
import org.wu.framework.core.exception.RuntimeExceptionFactory;
import org.wu.framework.core.io.ScriptResource;
import org.wu.framework.core.utils.StringUtils;

public class ScriptUtils {
    private static final Logger logger = LoggerFactory.getLogger(ScriptUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeSqlScript(Connection connection, ScriptResource resource, boolean ignoreFailedDrops, String[] commentPrefixes, String separator, String blockCommentStartDelimiter, String blockCommentEndDelimiter) throws ScriptException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Executing SQL script from " + resource);
            }
            long startTime = System.currentTimeMillis();
            String script = "";
            try {
                script = ScriptUtils.readScript(resource, commentPrefixes, blockCommentEndDelimiter);
            }
            catch (IOException ex) {
                RuntimeExceptionFactory.of((Throwable)ex);
            }
            if (separator == null) {
                separator = ";";
            }
            ArrayList<String> statements = new ArrayList<String>();
            ScriptUtils.splitSqlScript(resource, script, separator, commentPrefixes, blockCommentStartDelimiter, blockCommentEndDelimiter, statements);
            int stmtNumber = 0;
            Statement stmt = connection.createStatement();
            try {
                for (String statement : statements) {
                    ++stmtNumber;
                    try {
                        stmt.execute(statement);
                        int rowsAffected = stmt.getUpdateCount();
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug(rowsAffected + " returned as update count for SQL: " + statement);
                        for (SQLWarning warningToLog = stmt.getWarnings(); warningToLog != null; warningToLog = warningToLog.getNextWarning()) {
                            logger.debug("SQLWarning ignored: SQL state '" + warningToLog.getSQLState() + "', error code '" + warningToLog.getErrorCode() + "', message [" + warningToLog.getMessage() + "]");
                        }
                    }
                    catch (SQLException ex) {
                        ex.printStackTrace();
                        RuntimeExceptionFactory.of((String)statement, (Object[])new Object[]{stmtNumber, resource, ex});
                    }
                }
            }
            finally {
                try {
                    stmt.close();
                }
                catch (Throwable ex) {
                    logger.trace("Could not connectionClose JDBC Statement", ex);
                }
            }
            long elapsedTime = System.currentTimeMillis() - startTime;
            if (logger.isDebugEnabled()) {
                logger.debug("Executed SQL script from " + resource + " in " + elapsedTime + " ms.");
            }
        }
        catch (Exception ex) {
            if (ex instanceof ScriptException) {
                ScriptException scriptException = (ScriptException)ex;
                throw scriptException;
            }
            RuntimeExceptionFactory.of((String)("Failed to execute database script from resource [" + resource.getPath() + "]"), (Object[])new Object[]{ex});
        }
    }

    static String readScript(ScriptResource resource, String[] commentPrefixes, String blockCommentEndDelimiter) throws IOException {
        try (LineNumberReader lnr = new LineNumberReader(new InputStreamReader(resource.getInputStream()));){
            String string = ScriptUtils.readScript(lnr, commentPrefixes, blockCommentEndDelimiter);
            return string;
        }
    }

    public static String readScript(LineNumberReader lineNumberReader, String[] commentPrefixes, String blockCommentEndDelimiter) throws IOException {
        String currentStatement = lineNumberReader.readLine();
        StringBuilder scriptBuilder = new StringBuilder();
        while (currentStatement != null) {
            if (blockCommentEndDelimiter != null && currentStatement.contains(blockCommentEndDelimiter) || commentPrefixes != null && !ScriptUtils.startsWithAny(currentStatement, commentPrefixes, 0)) {
                if (scriptBuilder.length() > 0) {
                    scriptBuilder.append('\n');
                }
                scriptBuilder.append(currentStatement);
            }
            currentStatement = lineNumberReader.readLine();
        }
        return scriptBuilder.toString();
    }

    public static void splitSqlScript(ScriptResource resource, String script, String separator, String[] commentPrefixes, String blockCommentStartDelimiter, String blockCommentEndDelimiter, List<String> statements) throws ScriptException {
        AssertFactory.hasText((String)script, (String)"'script' must not be null or empty");
        AssertFactory.notNull((Object)separator, (String)"'separator' must not be null");
        AssertFactory.notNull((Object)commentPrefixes, (String)"'commentPrefixes' must not be null or empty");
        for (String commentPrefix : commentPrefixes) {
            AssertFactory.hasText((String)commentPrefix, (String)"'commentPrefixes' must not contain null or empty elements");
        }
        AssertFactory.hasText((String)blockCommentStartDelimiter, (String)"'blockCommentStartDelimiter' must not be null or empty");
        AssertFactory.hasText((String)blockCommentEndDelimiter, (String)"'blockCommentEndDelimiter' must not be null or empty");
        StringBuilder sb = new StringBuilder();
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        boolean inEscape = false;
        for (int i = 0; i < script.length(); ++i) {
            int c = script.charAt(i);
            if (inEscape) {
                inEscape = false;
                sb.append((char)c);
                continue;
            }
            if (c == 92) {
                inEscape = true;
                sb.append((char)c);
                continue;
            }
            if (!inDoubleQuote && c == 39) {
                inSingleQuote = !inSingleQuote;
            } else if (!inSingleQuote && c == 34) {
                boolean bl = inDoubleQuote = !inDoubleQuote;
            }
            if (!inSingleQuote && !inDoubleQuote) {
                if (script.startsWith(separator, i)) {
                    if (sb.length() > 0) {
                        statements.add(sb.toString());
                        sb = new StringBuilder();
                    }
                    i += separator.length() - 1;
                    continue;
                }
                if (ScriptUtils.startsWithAny(script, commentPrefixes, i)) {
                    int indexOfNextNewline = script.indexOf(10, i);
                    if (indexOfNextNewline <= i) break;
                    i = indexOfNextNewline;
                    continue;
                }
                if (script.startsWith(blockCommentStartDelimiter, i)) {
                    int indexOfCommentEnd = script.indexOf(blockCommentEndDelimiter, i);
                    if (indexOfCommentEnd > i) {
                        i = indexOfCommentEnd + blockCommentEndDelimiter.length() - 1;
                        continue;
                    }
                    RuntimeExceptionFactory.of((String)("Missing block comment end delimiter: " + blockCommentEndDelimiter + resource));
                } else if (c == 32 || c == 13 || c == 10 || c == 9) {
                    if (sb.length() <= 0 || sb.charAt(sb.length() - 1) == ' ') continue;
                    c = 32;
                }
            }
            sb.append((char)c);
        }
        if (StringUtils.hasText((CharSequence)sb)) {
            statements.add(sb.toString());
        }
    }

    private static boolean startsWithAny(String script, String[] prefixes, int offset) {
        for (String prefix : prefixes) {
            if (!script.startsWith(prefix, offset)) continue;
            return true;
        }
        return false;
    }
}

