/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.lambda.stream.lambda.insert;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wu.framework.core.utils.LazyListUtils;
import org.wu.framework.lazy.orm.database.lambda.stream.lambda.insert.SimpleInsertLambdaStream;
import org.wu.framework.translation.data.LayerDataAnalyzeAdapter;

public interface MultipleInsertLambdaStream
extends LayerDataAnalyzeAdapter,
SimpleInsertLambdaStream {
    public static final Logger log = LoggerFactory.getLogger(MultipleInsertLambdaStream.class);

    default public <T> void upsertMultiple(List<T> save) {
        this.upsertMultiple(save, 1000);
    }

    default public <T> void insertMultiple(List<T> save) {
        this.insertMultiple(save, 1000);
    }

    default public <T> void upsertMultiple(List<T> save, int groupSize) {
        this.splitListThen(save, groupSize, this::upsert);
    }

    default public <T> void insertMultiple(List<T> save, int groupSize) {
        this.splitListThen(save, groupSize, this::insert);
    }

    default public <T> void weakUpsertMultiple(String schema, String table, List<T> save, int groupSize) {
        this.splitListThen(save, groupSize, ts -> this.weakUpsert(schema, table, ts));
    }

    default public <T> void weakInsertMultiple(String schema, String table, List<T> save, int groupSize) {
        this.splitListThen(save, groupSize, ts -> this.weakInsert(schema, table, ts));
    }

    default public <T> void splitListThen(List<T> source, int groupSize, Consumer<List<T>> consumer) {
        Integer total = (source.size() + groupSize - 1) / groupSize;
        log.info("\u8ba1\u5212\u5904\u7406\u6b65\u9aa4 \u3010{}\u3011 \u6b65", (Object)total);
        AtomicInteger stepCount = new AtomicInteger(0);
        for (List ts : LazyListUtils.splitList(source, (int)groupSize)) {
            stepCount.getAndIncrement();
            consumer.accept(ts);
            log.info("\u5904\u7406\u6b65\u9aa4\u7b2c \u3010{}\u3011 \u6b65 ,\u603b\u6b65\u6570 \u3010{}\u3011", (Object)stepCount, (Object)total);
        }
    }
}

