/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.lambda.stream.function;

import java.lang.invoke.SerializedLambda;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.wu.framework.core.CamelAndUnderLineConverter;
import org.wu.framework.lazy.orm.database.lambda.stream.function.Snippet;
import org.wu.framework.lazy.orm.database.lambda.stream.support.LambdaMeta;
import org.wu.framework.lazy.orm.database.lambda.stream.support.SerializedLambdaMeta;
import org.wu.framework.lazy.orm.database.lambda.stream.support.toolkit.ReflectionKit;

public class SnippetUtil {
    public static <T> LambdaMeta extract(Snippet<T, ?> func) {
        try {
            Method method = func.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            Method accessible = ReflectionKit.setAccessible(method);
            Object invoke = accessible.invoke(func, new Object[0]);
            return new SerializedLambdaMeta((SerializedLambda)invoke);
        }
        catch (NoSuchMethodException e) {
            if (func instanceof Proxy) {
                return null;
            }
            String message = "Cannot find method writeReplace, please make sure that the lambda composite class is currently passed in";
            throw new RuntimeException(message);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static <T> String extractFieldName(Snippet<T, ?> func) {
        LambdaMeta meta = SnippetUtil.extract(func);
        assert (meta != null);
        String methodName = meta.methodName();
        return CamelAndUnderLineConverter.methodToField((String)methodName);
    }

    public static <T> String extractFieldNameHumpToLine2(Snippet<T, ?> func) {
        String field = SnippetUtil.extractFieldName(func);
        return CamelAndUnderLineConverter.humpToLine2((String)field);
    }
}

