/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.lambda.stream.execute;

import java.util.List;
import org.wu.framework.lazy.orm.database.lambda.LazyBaseOperation;
import org.wu.framework.lazy.orm.database.lambda.domain.LazyPage;
import org.wu.framework.lazy.orm.database.lambda.domain.PersistenceRepository;
import org.wu.framework.lazy.orm.database.lambda.stream.execute.Execute;

public abstract class AbstractExecute<T>
implements Execute<T> {
    private final LazyBaseOperation lazyOperation;

    protected AbstractExecute(LazyBaseOperation lazyOperation) {
        this.lazyOperation = lazyOperation;
    }

    protected abstract PersistenceRepository persistenceRepository();

    @Override
    public <R> List<R> collection(Class<R> aClass) {
        PersistenceRepository persistenceRepository = this.persistenceRepository();
        persistenceRepository.setResultClass(aClass);
        return this.lazyOperation.execute(persistenceRepository);
    }

    @Override
    public List<T> collection() {
        PersistenceRepository persistenceRepository = this.persistenceRepository();
        return this.lazyOperation.execute(persistenceRepository);
    }

    @Override
    public <R> LazyPage<R> page(LazyPage<R> lazyPage) {
        PersistenceRepository persistenceRepository = this.persistenceRepository();
        return this.lazyOperation.executePage(persistenceRepository, lazyPage);
    }

    @Override
    public <R> LazyPage<R> page(LazyPage<R> lazyPage, Class<R> rClass) {
        PersistenceRepository persistenceRepository = this.persistenceRepository();
        if (null != rClass) {
            persistenceRepository.setResultClass(rClass);
        }
        return this.lazyOperation.executePage(persistenceRepository, lazyPage);
    }

    @Override
    public <R> R collectOne(Class<R> aClass) {
        PersistenceRepository persistenceRepository = this.persistenceRepository();
        persistenceRepository.setResultClass(aClass);
        Object o = this.lazyOperation.executeOne(persistenceRepository);
        return (R)o;
    }

    @Override
    public T collectOne() {
        PersistenceRepository persistenceRepository = this.persistenceRepository();
        return (T)this.lazyOperation.executeOne(persistenceRepository);
    }
}

