/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.lambda.stream.condition.select;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.wu.framework.core.CamelAndUnderLineConverter;
import org.wu.framework.core.annotation.AnnotatedElementUtils;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.source.SqlSourceClass;
import org.wu.framework.lazy.orm.core.stereotype.field.LazyFieldCondition;
import org.wu.framework.lazy.orm.core.stereotype.field.LazyFieldSortOrder;
import org.wu.framework.lazy.orm.database.lambda.stream.condition.LambdaBasicComparison;
import org.wu.framework.lazy.orm.database.lambda.stream.condition.part.Condition;
import org.wu.framework.lazy.orm.database.lambda.stream.condition.part.SqlPart;

public class SelectBeanBasicComparison<T>
extends LambdaBasicComparison<T> {
    private final T bean;

    public SelectBeanBasicComparison(T bean) {
        this.bean = bean;
    }

    @Override
    public SqlPart getSqlPart() {
        this.sqlPart = super.getSqlPart();
        if (null != this.bean) {
            Class<?> classT = this.bean.getClass();
            SqlSourceClass sqlSourceClass = SqlSourceClass.getInstance(classT);
            String tableName = sqlSourceClass.getLazyTableEndpoint().getTableName();
            Map masterFieldMap = Arrays.stream(classT.getDeclaredFields()).map(Field::getName).collect(Collectors.toMap(s -> s, Function.identity()));
            Class<?> beanClass = this.bean.getClass();
            for (Field declaredField : beanClass.getDeclaredFields()) {
                String fieldName = declaredField.getName();
                if (!masterFieldMap.containsKey(fieldName)) continue;
                try {
                    LazyFieldCondition lazyFieldCondition;
                    LazyFieldSortOrder.SortOrder sortOrder;
                    declaredField.setAccessible(true);
                    Object value = declaredField.get(this.bean);
                    String columnName = CamelAndUnderLineConverter.humpToLine2((String)fieldName);
                    LazyFieldSortOrder lazyFieldSortOrder = (LazyFieldSortOrder)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)declaredField, LazyFieldSortOrder.class);
                    if (null != lazyFieldSortOrder && !LazyFieldSortOrder.SortOrder.NONE.equals((Object)(sortOrder = lazyFieldSortOrder.sortOrder()))) {
                        Condition condition = new Condition();
                        condition.setRowName(columnName);
                        condition.setType(sortOrder.name());
                        this.sqlPart.orderBy(condition);
                    }
                    if (null == (lazyFieldCondition = (LazyFieldCondition)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)declaredField, LazyFieldCondition.class))) {
                        if (ObjectUtils.isEmpty((Object)value)) continue;
                        this.sqlPart.put(tableName + "." + columnName, "=", value);
                        continue;
                    }
                    if (lazyFieldCondition.ignore() || lazyFieldCondition.ignoreEmpty() && null == value) continue;
                    this.sqlPart.put(columnName, lazyFieldCondition.condition(), value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return this.sqlPart;
    }

    @Override
    public Class<T> getClassT() {
        return this.bean.getClass();
    }
}

