/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.lambda.stream.condition.part;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.factory.LazyTableIdFactory;
import org.wu.framework.lazy.orm.core.factory.LazyTableStructureConverterFactory;
import org.wu.framework.lazy.orm.core.persistence.analyze.EasyAnnotationConverter;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyDatabaseJsonMessage;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableFieldEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableStructure;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableWeakStructure;
import org.wu.framework.lazy.orm.core.persistence.util.LazySQLUtil;
import org.wu.framework.lazy.orm.core.stereotype.LazyFieldStrategy;
import org.wu.framework.lazy.orm.core.stereotype.LazyTableFieldId;
import org.wu.framework.lazy.orm.database.lambda.domain.Persistence;
import org.wu.framework.lazy.orm.database.lambda.stream.condition.part.SqlPart;

public class LazyTableSqlPartConverterFactory {
    public static SqlPart upsert(Object bean) {
        return LazyTableSqlPartConverterFactory.insert(bean, Persistence.ExecutionEnum.UPSERT);
    }

    public static SqlPart insert(Object bean) {
        return LazyTableSqlPartConverterFactory.insert(bean, Persistence.ExecutionEnum.INSERT);
    }

    public static SqlPart insert(Object bean, Persistence.ExecutionEnum executionEnum) {
        SqlPart sqlPart = new SqlPart();
        sqlPart.setExecutionEnum(executionEnum);
        LazyTableStructure lazyTableStructure = LazyTableStructureConverterFactory.dataStructure((Object)bean);
        LazyTableEndpoint lazyTableEndpoint = lazyTableStructure.schema();
        List payload = lazyTableStructure.payload();
        String fullTableName = lazyTableEndpoint.getFullTableName();
        sqlPart.setPrimaryTable(fullTableName);
        List<HashMap<String, Object>> mapList = payload.stream().map(lazyTableFieldEndpoints -> lazyTableFieldEndpoints.stream().filter(fieldLazyTableFieldEndpoint -> !LazyFieldStrategy.NEVER.equals((Object)fieldLazyTableFieldEndpoint.getUpsertStrategy())).filter(convertedField -> !LazyDatabaseJsonMessage.ignoredFields.contains(convertedField.getName())).collect(HashMap::new, (map, lazyTableFieldEndpoint) -> {
            LazyFieldStrategy upsertStrategy;
            Object fieldValue = lazyTableFieldEndpoint.getFieldValue();
            if (ObjectUtils.isEmpty((Object)fieldValue) && LazyTableFieldId.IdType.INPUT_ID.equals((Object)lazyTableFieldEndpoint.getIdType())) {
                Class clazz = lazyTableFieldEndpoint.getClazz();
                fieldValue = LazyTableIdFactory.createId((Class)clazz);
            }
            if (LazyFieldStrategy.NOT_EMPTY.equals((Object)(upsertStrategy = lazyTableFieldEndpoint.getUpsertStrategy())) && "".equals(fieldValue)) {
                throw new RuntimeException(String.format("\u5b57\u6bb5\u3010%s\u3011\u4e0d\u80fd\u4e3a\u7a7a\u5b57\u7b26\u4e32", lazyTableFieldEndpoint.getField()));
            }
            if (LazyFieldStrategy.NOT_NULL.equals((Object)upsertStrategy) && null == fieldValue) {
                throw new RuntimeException(String.format("\u5b57\u6bb5\u3010%s\u3011\u4e0d\u80fd\u4e3aNULL", fieldValue));
            }
            if (null != (fieldValue = LazySQLUtil.valueToSqlValue((Object)fieldValue))) {
                fieldValue = EasyAnnotationConverter.annotationConvertConversion((Field)lazyTableFieldEndpoint.getField(), (Object)fieldValue, (Map)lazyTableEndpoint.getIEnumList());
                fieldValue = fieldValue.toString();
            } else {
                fieldValue = null;
            }
            map.put(lazyTableFieldEndpoint.getColumnName(), fieldValue);
        }, HashMap::putAll)).collect(Collectors.toList());
        sqlPart.setInsert(mapList);
        List convertedFieldList = lazyTableEndpoint.getLazyTableFieldEndpointList();
        Map<String, Object> insertDuplicateKey = convertedFieldList.stream().filter(lazyTableFieldEndpoint -> !LazyFieldStrategy.NEVER_JOIN_DUPLICATE_KEY.equals((Object)lazyTableFieldEndpoint.getUpsertStrategy())).collect(Collectors.toMap(LazyTableFieldEndpoint::getColumnName, lazyTableFieldEndpoint -> "VALUES (" + lazyTableFieldEndpoint.getColumnName() + ")"));
        sqlPart.setInsertDuplicateKey(insertDuplicateKey);
        return sqlPart;
    }

    public static SqlPart upsertWeak(String schema, String table, Object bean) {
        String tableName = ObjectUtils.isEmpty((Object)schema) ? table : schema + "." + table;
        return LazyTableSqlPartConverterFactory.insertWeak(bean, tableName, Persistence.ExecutionEnum.UPSERT);
    }

    public static SqlPart insertWeak(String schema, String table, Object bean) {
        String tableName = ObjectUtils.isEmpty((Object)schema) ? table : schema + "." + table;
        return LazyTableSqlPartConverterFactory.insertWeak(bean, tableName, Persistence.ExecutionEnum.INSERT);
    }

    public static SqlPart insertWeak(Object bean, String tableName, Persistence.ExecutionEnum executionEnum) {
        SqlPart sqlPart = new SqlPart();
        sqlPart.setExecutionEnum(executionEnum);
        sqlPart.setPrimaryTable(tableName);
        LazyTableWeakStructure lazyTableWeakStructure = LazyTableStructureConverterFactory.weakDataStructure((Object)bean);
        List<HashMap<String, Object>> insert = lazyTableWeakStructure.payload().stream().map(stringObjectMap -> {
            Map objectMap = stringObjectMap.entrySet().stream().collect(Collectors.toMap(stringObjectEntry -> "`" + (String)stringObjectEntry.getKey() + "`", Map.Entry::getValue, (existing, B) -> existing, LinkedHashMap::new));
            return new HashMap(objectMap);
        }).collect(Collectors.toList());
        sqlPart.setInsert(insert);
        Map<String, Object> insertDuplicateKey = lazyTableWeakStructure.schema().stream().collect(Collectors.toMap(Function.identity(), columnName -> "VALUES (" + columnName + ")"));
        sqlPart.setInsertDuplicateKey(insertDuplicateKey);
        return sqlPart;
    }
}

