/*
 * Decompiled with CFR 0.152.
 */
package org.wu.framework.lazy.orm.database.lambda.stream.condition;

import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.wu.framework.core.CamelAndUnderLineConverter;
import org.wu.framework.core.utils.ObjectUtils;
import org.wu.framework.lazy.orm.core.config.enums.RowValueType;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableEndpoint;
import org.wu.framework.lazy.orm.core.persistence.conf.LazyTableFieldEndpoint;
import org.wu.framework.lazy.orm.core.persistence.util.LazySQLUtil;
import org.wu.framework.lazy.orm.core.source.SqlSourceClass;
import org.wu.framework.lazy.orm.core.source.adapter.SourceFactory;
import org.wu.framework.lazy.orm.database.lambda.domain.Persistence;
import org.wu.framework.lazy.orm.database.lambda.stream.BasicAsComparison;
import org.wu.framework.lazy.orm.database.lambda.stream.BasicConcatComparison;
import org.wu.framework.lazy.orm.database.lambda.stream.condition.AbstractJoinBasicComparison;
import org.wu.framework.lazy.orm.database.lambda.stream.condition.BasicComparison;
import org.wu.framework.lazy.orm.database.lambda.stream.condition.part.Condition;
import org.wu.framework.lazy.orm.database.lambda.stream.condition.part.SqlPart;
import org.wu.framework.lazy.orm.database.lambda.stream.function.Snippet;
import org.wu.framework.lazy.orm.database.lambda.stream.function.SnippetUtil;
import org.wu.framework.lazy.orm.database.lambda.stream.support.LambdaMeta;

public abstract class AbstractBasicComparison<T, R, V>
implements BasicComparison<T, R, V, AbstractBasicComparison<T, R, V>>,
BasicAsComparison<T, R, V, AbstractBasicComparison<T, R, V>>,
BasicConcatComparison<T, R, V, AbstractBasicComparison<T, R, V>> {
    protected SqlPart sqlPart = new SqlPart(" WHERE ");

    public <T1, T2> AbstractBasicComparison<T, R, V> internalJoin(AbstractJoinBasicComparison<T1, T2, Snippet<T1, ?>, Snippet<T2, ?>> internalJoinBasicComparison) {
        SqlPart sqlPart = internalJoinBasicComparison.getSqlPart();
        Class<?> entityClass = sqlPart.getPrimaryClass();
        SqlSourceClass sqlSourceClass = SqlSourceClass.getInstance(entityClass);
        String tableName = sqlSourceClass.getLazyTableEndpoint().getTableName();
        sqlPart.setPrefix(" inner join ");
        sqlPart.setConditionType("on");
        sqlPart.setPrimaryTable(tableName);
        sqlPart.setPrimaryClass(entityClass);
        this.sqlPart.join(sqlPart);
        return this;
    }

    public <T1, T2> AbstractBasicComparison<T, R, V> leftJoin(AbstractJoinBasicComparison<T1, T2, Snippet<T1, ?>, Snippet<T2, ?>> leftJoinBasicComparison) {
        SqlPart sqlPart = leftJoinBasicComparison.getSqlPart();
        Class<?> entityClass = sqlPart.getPrimaryClass();
        SqlSourceClass sqlSourceClass = SqlSourceClass.getInstance(entityClass);
        String tableName = sqlSourceClass.getLazyTableEndpoint().getTableName();
        sqlPart.setPrefix("left join ");
        sqlPart.setConditionType("on");
        sqlPart.setPrimaryTable(tableName);
        sqlPart.setPrimaryClass(entityClass);
        this.sqlPart.join(sqlPart);
        return this;
    }

    public <T1, T2> AbstractBasicComparison<T, R, V> rightJoin(AbstractJoinBasicComparison<T1, T2, Snippet<T1, ?>, Snippet<T2, ?>> rightJoinBasicComparison) {
        SqlPart sqlPart = rightJoinBasicComparison.getSqlPart();
        Class<?> entityClass = sqlPart.getPrimaryClass();
        SqlSourceClass sqlSourceClass = SqlSourceClass.getInstance(entityClass);
        String tableName = sqlSourceClass.getLazyTableEndpoint().getTableName();
        sqlPart.setPrefix("right join ");
        sqlPart.setConditionType("on");
        sqlPart.setPrimaryTable(tableName);
        sqlPart.setPrimaryClass(entityClass);
        this.sqlPart.join(sqlPart);
        return this;
    }

    public <T2> AbstractBasicComparison<T, R, V> where(AbstractJoinBasicComparison<T, T2, Snippet<T, ?>, Snippet<T2, ?>> whereAbstractJoinBasicComparison) {
        SqlPart sqlPart = whereAbstractJoinBasicComparison.getSqlPart();
        this.sqlPart.getConditionList().addAll(sqlPart.getConditionList());
        return this;
    }

    public <T2> AbstractBasicComparison<T, R, V> or(BasicComparison orAbstractJoinBasicComparison) {
        SqlPart sqlPart = orAbstractJoinBasicComparison.getSqlPart();
        this.sqlPart.or(sqlPart);
        return this;
    }

    public <T2> AbstractBasicComparison<T, R, V> having(AbstractJoinBasicComparison<T, T2, Snippet<T, ?>, Snippet<T2, ?>> havingBasicComparison) {
        SqlPart sqlPart = havingBasicComparison.getSqlPart();
        sqlPart.setPrefix("HAVING  ");
        sqlPart.setConditionType("");
        this.sqlPart.having(sqlPart);
        return this;
    }

    @Override
    public AbstractBasicComparison<T, R, V> functionAs(String function, String asName) {
        this.sqlPart.columnAs(function, asName);
        return this;
    }

    @Override
    public <T2> AbstractBasicComparison<T, R, V> functionAs(String function, Snippet<T2, ?> asRowName) {
        LambdaMeta meta = SnippetUtil.extract(asRowName);
        assert (meta != null);
        String methodName = meta.methodName();
        String field = CamelAndUnderLineConverter.methodToField((String)methodName);
        String asName = CamelAndUnderLineConverter.humpToLine2((String)field);
        this.sqlPart.columnAs(function, asName);
        return this;
    }

    @Override
    public AbstractBasicComparison<T, R, V> oas(String row, String asName) {
        this.sqlPart.columnAs("'" + row + "'", asName);
        return this;
    }

    @Override
    public <T2> AbstractBasicComparison<T, R, V> oas(String row, Snippet<T2, ?> asRowName) {
        LambdaMeta meta = SnippetUtil.extract(asRowName);
        assert (meta != null);
        String methodName = meta.methodName();
        String field = CamelAndUnderLineConverter.methodToField((String)methodName);
        String asName = CamelAndUnderLineConverter.humpToLine2((String)field);
        this.sqlPart.columnAs("'" + row + "'", asName);
        return this;
    }

    @Override
    public AbstractBasicComparison<T, R, V> as(Class<?> clazz) {
        SqlSourceClass sqlSourceClass = SqlSourceClass.getInstance(clazz);
        LazyTableEndpoint lazyTableEndpoint = sqlSourceClass.getLazyTableEndpoint();
        List fieldEndpoints = lazyTableEndpoint.getLazyTableFieldEndpointList();
        for (LazyTableFieldEndpoint fieldEndpoint : fieldEndpoints) {
            String asName = fieldEndpoint.getColumnName();
            String tableFullColumnName = lazyTableEndpoint.getFullTableName() + "." + asName;
            this.sqlPart.columnAs(tableFullColumnName, asName);
        }
        return this;
    }

    @Override
    public AbstractBasicComparison<T, R, V> as(R row, String asName) {
        this.sqlPart.columnAs(this.columnToString(row), asName);
        return this;
    }

    @Override
    public <T1, T2> AbstractBasicComparison<T, R, V> as(Snippet<T1, ?> row, Snippet<T2, ?> asRowName) {
        LambdaMeta meta = SnippetUtil.extract(asRowName);
        assert (meta != null);
        String methodName = meta.methodName();
        String field = CamelAndUnderLineConverter.methodToField((String)methodName);
        String asName = CamelAndUnderLineConverter.humpToLine2((String)field);
        LambdaMeta rowMeta = SnippetUtil.extract(row);
        assert (rowMeta != null);
        Class<?> rowClass = rowMeta.instantiatedClass();
        String rowMethodName = rowMeta.methodName();
        String rowField = CamelAndUnderLineConverter.methodToField((String)rowMethodName);
        String rowName = CamelAndUnderLineConverter.humpToLine2((String)rowField);
        SqlSourceClass sqlSourceClass = SqlSourceClass.getInstance(rowClass);
        String tableName = sqlSourceClass.getLazyTableEndpoint().getTableName();
        this.sqlPart.columnAs(tableName + "." + rowName, asName);
        return this;
    }

    @Override
    public <T1, T2, T3> AbstractBasicComparison<T, R, V> as(BasicComparison<T1, ?, ?, ?> comparison, Snippet<T3, ?> asRowName) {
        LambdaMeta meta = SnippetUtil.extract(asRowName);
        assert (meta != null);
        String methodName = meta.methodName();
        String field = CamelAndUnderLineConverter.methodToField((String)methodName);
        String asName = CamelAndUnderLineConverter.humpToLine2((String)field);
        SqlPart sqlPart = comparison.getSqlPart();
        Class classT = comparison.getClassT();
        LazyTableEndpoint lazyTableEndpoint = SourceFactory.defaultAnalyzeLazyTableFromClass(classT);
        sqlPart.setExecutionEnum(Persistence.ExecutionEnum.SELECT);
        sqlPart.setPrimaryClass(classT);
        sqlPart.setPrimaryTable(lazyTableEndpoint.getFullTableName());
        String sql = sqlPart.sql();
        this.sqlPart.columnAs("(" + sql + ")", asName);
        return this;
    }

    @Override
    public <T1, T2, T3> AbstractBasicComparison<T, R, V> as(BasicComparison<T1, ?, ?, ?> comparison, String asRowName) {
        SqlPart sqlPart = comparison.getSqlPart();
        Class classT = comparison.getClassT();
        SqlSourceClass sqlSourceClass = SqlSourceClass.getInstance(classT);
        LazyTableEndpoint lazyTableEndpoint = sqlSourceClass.getLazyTableEndpoint();
        sqlPart.setExecutionEnum(Persistence.ExecutionEnum.SELECT);
        sqlPart.setPrimaryClass(classT);
        sqlPart.setPrimaryTable(lazyTableEndpoint.getFullTableName());
        String sql = sqlPart.sql();
        this.sqlPart.columnAs("(" + sql + ")", asRowName);
        return this;
    }

    @Override
    public <T1> AbstractBasicComparison<T, R, V> ignoreAs(Snippet<T1, ?> row) {
        LambdaMeta rowMeta = SnippetUtil.extract(row);
        assert (rowMeta != null);
        Class<?> rowClass = rowMeta.instantiatedClass();
        String rowMethodName = rowMeta.methodName();
        String field = CamelAndUnderLineConverter.methodToField((String)rowMethodName);
        String rowName = CamelAndUnderLineConverter.humpToLine2((String)field);
        SqlSourceClass sqlSourceClass = SqlSourceClass.getInstance(rowClass);
        String tableName = sqlSourceClass.getLazyTableEndpoint().getTableName();
        this.sqlPart.ignoreColumnAs(tableName + "." + rowName);
        return this;
    }

    @Override
    public AbstractBasicComparison<T, R, V> onlyUseAs() {
        this.sqlPart.setOnlyUseAs(true);
        return this;
    }

    @Override
    public AbstractBasicComparison<T, R, V> apply(boolean condition, String applySql, Object ... values) {
        if (condition) {
            if (ObjectUtils.isEmpty((Object)applySql)) {
                return this;
            }
            this.sqlPart.put(String.format(applySql, values), " ", RowValueType.EXPRESSION, (Object)" ");
        }
        return this;
    }

    @Override
    public AbstractBasicComparison<T, R, V> eq(boolean condition, R row, V v) {
        if (condition) {
            this.sqlPart.put(this.columnToString(row), "=", this.valueToString(v));
        }
        return this;
    }

    @Override
    public AbstractBasicComparison<T, R, V> or(boolean condition, R row, V v) {
        if (condition) {
            this.sqlPart.put(Condition.AndOr.OR, (Object)this.columnToString(row), "=", this.valueToString(v));
        }
        return this;
    }

    @Override
    public AbstractBasicComparison<T, R, V> eqo(boolean condition, R row, Object var) {
        if (condition) {
            this.sqlPart.put(this.columnToString(row), "=", var);
        }
        return this;
    }

    @Override
    public AbstractBasicComparison<T, R, V> ne(boolean condition, R row, V v) {
        if (condition) {
            this.sqlPart.put(this.columnToString(row), "!=", this.valueToString(v));
        }
        return this;
    }

    @Override
    public AbstractBasicComparison<T, R, V> neo(boolean condition, R row, Object var) {
        if (condition) {
            this.sqlPart.put(this.columnToString(row), "!=", var);
        }
        return this;
    }

    @Override
    public AbstractBasicComparison<T, R, V> notNull(R row) {
        this.sqlPart.put(this.columnToString(row), " is not ", null);
        return this;
    }

    @Override
    public AbstractBasicComparison<T, R, V> isNull(R row) {
        this.sqlPart.put(this.columnToString(row), "IS", null);
        return this;
    }

    @Override
    public AbstractBasicComparison<T, R, V> gt(boolean condition, R row, V var) {
        if (condition) {
            this.sqlPart.put(this.columnToString(row), ">", this.valueToString(var));
        }
        return this;
    }

    @Override
    public AbstractBasicComparison<T, R, V> gto(boolean condition, R row, Object var) {
        if (condition) {
            this.sqlPart.put(this.columnToString(row), ">", var);
        }
        return this;
    }

    @Override
    public AbstractBasicComparison<T, R, V> lt(boolean condition, R row, V var) {
        if (condition) {
            this.sqlPart.put(this.columnToString(row), "<", this.valueToString(var));
        }
        return this;
    }

    @Override
    public AbstractBasicComparison<T, R, V> lto(boolean condition, R row, Object var) {
        if (condition) {
            this.sqlPart.put(this.columnToString(row), "<", var);
        }
        return this;
    }

    @Override
    public AbstractBasicComparison<T, R, V> like(boolean condition, R row, V var) {
        if (condition) {
            this.sqlPart.put(this.columnToString(row), "like", "%" + this.valueToString(var) + "%");
        }
        return this;
    }

    @Override
    public AbstractBasicComparison<T, R, V> lLike(boolean condition, R row, V var) {
        if (condition) {
            this.sqlPart.put(this.columnToString(row), "like", this.valueToString(var) + "%");
        }
        return this;
    }

    @Override
    public AbstractBasicComparison<T, R, V> gLike(boolean condition, R row, V var) {
        if (condition) {
            this.sqlPart.put(this.columnToString(row), "like", "%" + this.valueToString(var));
        }
        return this;
    }

    @Override
    public AbstractBasicComparison<T, R, V> likeO(boolean condition, R row, Object var) {
        if (condition) {
            this.sqlPart.put(this.columnToString(row), "like", var);
        }
        return this;
    }

    @Override
    public AbstractBasicComparison<T, R, V> notLike(boolean condition, R row, V var) {
        if (condition) {
            this.sqlPart.put(this.columnToString(row), "not like", this.valueToString(var));
        }
        return this;
    }

    @Override
    public AbstractBasicComparison<T, R, V> notLikeO(boolean condition, R row, Object var) {
        if (condition) {
            this.sqlPart.put(this.columnToString(row), "not like", var);
        }
        return this;
    }

    @Override
    public AbstractBasicComparison<T, R, V> in(boolean condition, R row, V var) {
        if (condition) {
            if (Collection.class.isAssignableFrom(var.getClass())) {
                String in = ((Collection)var).stream().map(va -> LazySQLUtil.sqlValue((Object)va).toString()).collect(Collectors.joining(","));
                this.sqlPart.put(this.columnToString(row), "in", RowValueType.EXPRESSION, (Object)("(" + LazySQLUtil.sqlValue((Object)in, (boolean)false) + ")"));
            } else {
                this.sqlPart.put(this.columnToString(row), "in", RowValueType.EXPRESSION, (Object)("(" + LazySQLUtil.sqlValue(var, (boolean)false) + ")"));
            }
        }
        return this;
    }

    @Override
    public AbstractBasicComparison<T, R, V> inOr(boolean condition, R row, V var) {
        if (condition) {
            if (Collection.class.isAssignableFrom(var.getClass())) {
                String columnName = this.columnToString(row);
                String or = ((Collection)var).stream().map(va -> " " + columnName + " " + "=" + " " + LazySQLUtil.sqlValue((Object)va) + " ").collect(Collectors.joining("or"));
                this.sqlPart.put("(", or, RowValueType.EXPRESSION, (Object)")");
            } else {
                this.sqlPart.put(this.columnToString(row), "in", RowValueType.EXPRESSION, (Object)("(" + LazySQLUtil.sqlValue(var, (boolean)false) + ")"));
            }
        }
        return this;
    }

    @Override
    public AbstractBasicComparison<T, R, V> ino(boolean condition, R row, Object var) {
        if (condition) {
            if (Collection.class.isAssignableFrom(var.getClass())) {
                String in = ((Collection)var).stream().map(va -> LazySQLUtil.sqlValue((Object)va).toString()).collect(Collectors.joining(","));
                this.sqlPart.put(this.columnToString(row), "in", RowValueType.EXPRESSION, (Object)("(" + LazySQLUtil.sqlValue((Object)in, (boolean)false) + ")"));
            } else {
                this.sqlPart.put(this.columnToString(row), "in", RowValueType.EXPRESSION, (Object)("(" + LazySQLUtil.sqlValue((Object)var, (boolean)false) + ")"));
            }
        }
        return this;
    }

    @Override
    public AbstractBasicComparison<T, R, V> notIn(boolean condition, R row, V var) {
        if (condition) {
            if (Collection.class.isAssignableFrom(var.getClass())) {
                String in = ((Collection)var).stream().map(va -> "'" + va.toString() + "'").collect(Collectors.joining(","));
                this.sqlPart.put(this.columnToString(row), "not in", RowValueType.EXPRESSION, (Object)("(" + in + ")"));
            } else {
                this.sqlPart.put(this.columnToString(row), "not in", RowValueType.EXPRESSION, (Object)("(" + var + ")"));
            }
        }
        return this;
    }

    @Override
    public AbstractBasicComparison<T, R, V> notIno(boolean condition, R row, Object var) {
        if (condition) {
            if (Collection.class.isAssignableFrom(var.getClass())) {
                String in = ((Collection)var).stream().map(va -> "'" + va.toString() + "'").collect(Collectors.joining(","));
                this.sqlPart.put(this.columnToString(row), "not in", RowValueType.EXPRESSION, (Object)("(" + in + ")"));
            } else {
                this.sqlPart.put(this.columnToString(row), "not in", RowValueType.EXPRESSION, (Object)("(" + var + ")"));
            }
        }
        return this;
    }

    @Override
    public AbstractBasicComparison<T, R, V> between(boolean condition, R row, Object leftVar, Object rightVar) {
        if (condition) {
            this.sqlPart.put(this.columnToString(row), "between", leftVar);
            this.sqlPart.put(this.columnToString(row), "and", rightVar);
        }
        return this;
    }

    @Override
    public AbstractBasicComparison<T, R, V> betweenO(boolean condition, R row, Object leftVar, Object rightVar) {
        if (condition) {
            this.sqlPart.put(this.columnToString(row), "between", leftVar);
            this.sqlPart.put(this.columnToString(row), "and", rightVar);
        }
        return this;
    }

    @Override
    public AbstractBasicComparison<T, R, V> groupBy(R ... rows) {
        for (R row : rows) {
            String rowName = this.columnToString(row);
            Condition condition = new Condition();
            condition.setRowName(rowName);
            this.sqlPart.groupBy(condition);
        }
        return this;
    }

    @Override
    public AbstractBasicComparison<T, R, V> orderBy(String order, R ... rows) {
        for (R row : rows) {
            String rowName = this.columnToString(row);
            Condition condition = new Condition();
            condition.setRowName(rowName);
            condition.setType(order);
            this.sqlPart.orderBy(condition);
        }
        return this;
    }

    @Override
    public AbstractBasicComparison<T, R, V> limit(long limit) {
        this.sqlPart.setLimitSql(" limit " + limit + " ");
        return this;
    }

    @Override
    public AbstractBasicComparison<T, R, V> limit(long skipped, long limit) {
        this.sqlPart.setLimitSql(" limit " + skipped + "," + limit + " ");
        return this;
    }

    @Override
    public AbstractBasicComparison<T, R, V> lastSql(String lastSql) {
        this.sqlPart.setLastSql(lastSql);
        return this;
    }

    @Override
    public SqlPart getSqlPart() {
        return this.sqlPart;
    }

    @Override
    public Class<T> getClassT() {
        ParameterizedType superClass = (ParameterizedType)this.getClass().getGenericSuperclass();
        Class type = (Class)superClass.getActualTypeArguments()[0];
        return type;
    }

    protected String columnToString(R row) {
        return (String)row;
    }

    protected Object valueToString(V v) {
        return v;
    }
}

